/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.infuse;

import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.infuse.InfuseTypeBuilder;
import mekanism.api.chemical.infuse.InfuseTypeTags;
import mekanism.api.providers.IInfuseTypeProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.util.ReverseTagWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class InfuseType
extends Chemical<InfuseType>
implements IInfuseTypeProvider {
    private final ReverseTagWrapper<InfuseType> reverseTags = new ReverseTagWrapper((Object)this, InfuseTypeTags::getGeneration, InfuseTypeTags::getCollection);

    public InfuseType(InfuseTypeBuilder builder) {
        super(builder);
    }

    public static InfuseType readFromNBT(@Nullable CompoundNBT nbtTags) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return MekanismAPI.EMPTY_INFUSE_TYPE;
        }
        return InfuseType.getFromRegistry(new ResourceLocation(nbtTags.func_74779_i("infuseTypeName")));
    }

    public static InfuseType getFromRegistry(@Nullable ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return MekanismAPI.EMPTY_INFUSE_TYPE;
        }
        InfuseType infuseType = (InfuseType)MekanismAPI.INFUSE_TYPE_REGISTRY.getValue(resourceLocation);
        if (infuseType == null) {
            return MekanismAPI.EMPTY_INFUSE_TYPE;
        }
        return infuseType;
    }

    @Override
    public InfuseType getInfuseType() {
        return this;
    }

    public String toString() {
        return "[InfuseType: " + this.getRegistryName() + "]";
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        nbtTags.func_74778_a("infuseTypeName", this.getRegistryName().toString());
        return nbtTags;
    }

    @Override
    public boolean isIn(Tag<InfuseType> tag) {
        return tag.func_199685_a_((Object)this);
    }

    @Override
    public Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    @Override
    public final boolean isEmptyType() {
        return this == MekanismAPI.EMPTY_INFUSE_TYPE;
    }

    @Override
    protected String getDefaultTranslationKey() {
        return Util.func_200697_a((String)"infuse_type", (ResourceLocation)this.getRegistryName());
    }
}

