/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.gas;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface ISidedGasHandler
extends IGasHandler {
    @Nullable
    default public Direction getGasSideFor() {
        return null;
    }

    public int getGasTankCount(@Nullable Direction var1);

    @Override
    default public int getGasTankCount() {
        return this.getGasTankCount(this.getGasSideFor());
    }

    public GasStack getGasInTank(int var1, @Nullable Direction var2);

    @Override
    default public GasStack getGasInTank(int tank) {
        return this.getGasInTank(tank, this.getGasSideFor());
    }

    public void setGasInTank(int var1, GasStack var2, @Nullable Direction var3);

    @Override
    default public void setGasInTank(int tank, GasStack stack) {
        this.setGasInTank(tank, stack, this.getGasSideFor());
    }

    public long getGasTankCapacity(int var1, @Nullable Direction var2);

    @Override
    default public long getGasTankCapacity(int tank) {
        return this.getGasTankCapacity(tank, this.getGasSideFor());
    }

    public boolean isGasValid(int var1, GasStack var2, @Nullable Direction var3);

    @Override
    default public boolean isGasValid(int tank, GasStack stack) {
        return this.isGasValid(tank, stack, this.getGasSideFor());
    }

    public GasStack insertGas(int var1, GasStack var2, @Nullable Direction var3, Action var4);

    @Override
    default public GasStack insertGas(int tank, GasStack stack, Action action) {
        return this.insertGas(tank, stack, this.getGasSideFor(), action);
    }

    public GasStack extractGas(int var1, long var2, @Nullable Direction var4, Action var5);

    @Override
    default public GasStack extractGas(int tank, long amount, Action action) {
        return this.extractGas(tank, amount, this.getGasSideFor(), action);
    }

    default public GasStack insertGas(GasStack stack, @Nullable Direction side, Action action) {
        return ChemicalUtils.insert(stack, action, GasStack.EMPTY, () -> this.getGasTankCount(side), tank -> this.getGasInTank(tank, side), (tank, s, a) -> this.insertGas(tank, (GasStack)s, side, a));
    }

    default public GasStack extractGas(long amount, @Nullable Direction side, Action action) {
        return ChemicalUtils.extract(amount, action, GasStack.EMPTY, () -> this.getGasTankCount(side), tank -> this.getGasInTank(tank, side), (tank, a, act) -> this.extractGas(tank, a, side, act));
    }

    default public GasStack extractGas(GasStack stack, @Nullable Direction side, Action action) {
        return ChemicalUtils.extract(stack, action, GasStack.EMPTY, () -> this.getGasTankCount(side), tank -> this.getGasInTank(tank, side), (tank, a, act) -> this.extractGas(tank, a, side, act));
    }
}

