/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class Chemical<TYPE extends Chemical<TYPE>>
extends ForgeRegistryEntry<TYPE>
implements IHasTextComponent,
IHasTranslationKey {
    private Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> attributeMap;
    private final ResourceLocation iconLocation;
    private final int tint;
    private String translationKey;

    protected Chemical(ChemicalBuilder<TYPE, ?> builder) {
        this.attributeMap = builder.getAttributeMap();
        this.iconLocation = builder.getTexture();
        this.tint = builder.getColor();
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = this.getDefaultTranslationKey();
        }
        return this.translationKey;
    }

    public boolean has(Class<? extends ChemicalAttribute> type) {
        return this.attributeMap.containsKey(type);
    }

    @Nullable
    public <T extends ChemicalAttribute> T get(Class<T> type) {
        return (T)this.attributeMap.get(type);
    }

    public Collection<ChemicalAttribute> getAttributes() {
        return this.attributeMap.values();
    }

    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return this.attributeMap.keySet();
    }

    public abstract CompoundNBT write(CompoundNBT var1);

    protected abstract String getDefaultTranslationKey();

    @Override
    public ITextComponent getTextComponent() {
        return new TranslationTextComponent(this.getTranslationKey(), new Object[0]);
    }

    public ResourceLocation getIcon() {
        return this.iconLocation;
    }

    public int getTint() {
        return this.tint;
    }

    public abstract boolean isIn(Tag<TYPE> var1);

    public abstract Set<ResourceLocation> getTags();

    public abstract boolean isEmptyType();
}

