/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers1;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers2;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers4;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawersComp;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class BlockDrawers
extends HorizontalBlock
implements INetworked {
    private static final VoxelShape AABB_FULL = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_NORTH_FULL = VoxelShapes.func_197878_a((VoxelShape)AABB_FULL, (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape AABB_SOUTH_FULL = VoxelShapes.func_197878_a((VoxelShape)AABB_FULL, (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape AABB_WEST_FULL = VoxelShapes.func_197878_a((VoxelShape)AABB_FULL, (VoxelShape)Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape AABB_EAST_FULL = VoxelShapes.func_197878_a((VoxelShape)AABB_FULL, (VoxelShape)Block.func_208617_a((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape AABB_NORTH_HALF = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_SOUTH_HALF = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape AABB_WEST_HALF = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_EAST_HALF = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private final int drawerCount;
    private final boolean halfDepth;
    private final int storageUnits;
    public final AxisAlignedBB[] slotGeometry;
    public final AxisAlignedBB[] countGeometry;
    public final AxisAlignedBB[] labelGeometry;
    private long ignoreEventTime;
    private static final ThreadLocal<Boolean> inTileLookup = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public BlockDrawers(int drawerCount, boolean halfDepth, int storageUnits, Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH));
        this.drawerCount = drawerCount;
        this.halfDepth = halfDepth;
        this.storageUnits = storageUnits;
        this.slotGeometry = new AxisAlignedBB[drawerCount];
        this.countGeometry = new AxisAlignedBB[drawerCount];
        this.labelGeometry = new AxisAlignedBB[drawerCount];
        for (int i = 0; i < drawerCount; ++i) {
            this.slotGeometry[i] = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.countGeometry[i] = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.labelGeometry[i] = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D});
    }

    public boolean retrimBlock(World world, BlockPos pos, ItemStack prototype) {
        return false;
    }

    public BlockType retrimType() {
        return BlockType.Drawers;
    }

    public int getDrawerCount() {
        return this.drawerCount;
    }

    public boolean isHalfDepth() {
        return this.halfDepth;
    }

    public int getStorageUnits() {
        return this.storageUnits;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initDynamic() {
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
        switch (direction) {
            case EAST: {
                return this.halfDepth ? AABB_EAST_HALF : AABB_EAST_FULL;
            }
            case WEST: {
                return this.halfDepth ? AABB_WEST_HALF : AABB_WEST_FULL;
            }
            case SOUTH: {
                return this.halfDepth ? AABB_SOUTH_HALF : AABB_SOUTH_FULL;
            }
        }
        return this.halfDepth ? AABB_NORTH_HALF : AABB_NORTH_FULL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        IDrawerAttributes _attrs;
        TileEntityDrawers tile;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tile") && (tile = this.getTileEntity((IBlockReader)world, pos)) != null) {
            tile.readPortable(stack.func_77978_p().func_74775_l("tile"));
        }
        if (stack.func_82837_s()) {
            tile = this.getTileEntity((IBlockReader)world, pos);
        }
        if (entity.func_184592_cb().func_77973_b() == ModItems.DRAWER_KEY && (tile = this.getTileEntity((IBlockReader)world, pos)) != null && (_attrs = (IDrawerAttributes)tile.getCapability(CapabilityDrawerAttributes.DRAWER_ATTRIBUTES_CAPABILITY).orElse((Object)new EmptyDrawerAttributes())) instanceof IDrawerAttributesModifiable) {
            IDrawerAttributesModifiable attrs = (IDrawerAttributesModifiable)_attrs;
            attrs.setItemLocked(LockAttribute.LOCK_EMPTY, true);
            attrs.setItemLocked(LockAttribute.LOCK_POPULATED, true);
        }
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        if (useContext.func_195999_j().func_184812_l_() && useContext.func_221531_n() == Hand.OFF_HAND) {
            double blockReachDistance = useContext.func_195999_j().func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e() + 1.0;
            BlockRayTraceResult result = this.rayTraceEyes(useContext.func_195991_k(), useContext.func_195999_j(), blockReachDistance);
            if (result.func_216346_c() == RayTraceResult.Type.MISS || result.func_216354_b() != state.func_177229_b((IProperty)field_185512_D)) {
                useContext.func_195991_k().func_180501_a(useContext.func_195995_a(), Blocks.field_150350_a.func_176223_P(), useContext.func_195991_k().field_72995_K ? 11 : 3);
            } else {
                this.func_196270_a(state, useContext.func_195991_k(), useContext.func_195995_a(), useContext.func_195999_j());
            }
            return false;
        }
        return super.func_196253_a(state, useContext);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack item = player.func_184586_b(hand);
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K && Util.func_211177_b() == this.ignoreEventTime) {
            this.ignoreEventTime = 0L;
            return ActionResultType.PASS;
        }
        final TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, pos);
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info("BlockDrawers.onBlockActivated");
            StorageDrawers.log.info(item.func_190926_b() ? "  null item" : "  " + item.toString());
        }
        if (!item.func_190926_b()) {
            if (item.func_77973_b() instanceof ItemKey) {
                return ActionResultType.PASS;
            }
            if (item.func_77973_b() instanceof ItemUpgrade) {
                if (!tileDrawers.upgrades().canAddUpgrade(item)) {
                    if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.storagedrawers.cannot_add_upgrade", new Object[0]), true);
                    }
                    return ActionResultType.PASS;
                }
                if (!tileDrawers.upgrades().addUpgrade(item)) {
                    if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.storagedrawers.max_upgrades", new Object[0]), true);
                    }
                    return ActionResultType.PASS;
                }
                world.func_184138_a(pos, state, state, 3);
                if (!player.func_184812_l_()) {
                    item.func_190918_g(1);
                    if (item.func_190916_E() <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        } else if (item.func_190926_b() && player.func_225608_bj_() && ((Boolean)CommonConfig.GENERAL.enableUI.get()).booleanValue() && !world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent(BlockDrawers.this.func_149739_a(), new Object[0]);
                }

                @Nullable
                public Container createMenu(int windowId, PlayerInventory playerInv, PlayerEntity playerEntity) {
                    if (BlockDrawers.this.drawerCount == 1) {
                        return new ContainerDrawers1(windowId, playerInv, tileDrawers);
                    }
                    if (BlockDrawers.this.drawerCount == 2) {
                        return new ContainerDrawers2(windowId, playerInv, tileDrawers);
                    }
                    if (BlockDrawers.this.drawerCount == 4) {
                        return new ContainerDrawers4(windowId, playerInv, tileDrawers);
                    }
                    if (BlockDrawers.this.drawerCount == 3 && BlockDrawers.this instanceof BlockCompDrawers) {
                        return new ContainerDrawersComp(windowId, playerInv, tileDrawers);
                    }
                    return null;
                }
            }, extraData -> extraData.func_179255_a(pos));
            return ActionResultType.SUCCESS;
        }
        if (state.func_177229_b((IProperty)field_185512_D) != hit.func_216354_b()) {
            return ActionResultType.PASS;
        }
        int slot = this.getDrawerSlot(hit);
        tileDrawers.interactPutItemsIntoSlot(slot, player);
        if (item.func_190926_b()) {
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
        return ActionResultType.SUCCESS;
    }

    protected final int getDrawerSlot(BlockRayTraceResult hit) {
        return this.getDrawerSlot(hit.func_216354_b(), this.normalizeHitVec(hit.func_216347_e()));
    }

    private Vec3d normalizeHitVec(Vec3d hit) {
        return new Vec3d((hit.field_72450_a < 0.0 ? hit.field_72450_a - Math.floor(hit.field_72450_a) : hit.field_72450_a) % 1.0, (hit.field_72448_b < 0.0 ? hit.field_72448_b - Math.floor(hit.field_72448_b) : hit.field_72448_b) % 1.0, (hit.field_72449_c < 0.0 ? hit.field_72449_c - Math.floor(hit.field_72449_c) : hit.field_72449_c) % 1.0);
    }

    protected int getDrawerSlot(Direction side, Vec3d hit) {
        return 0;
    }

    protected boolean hitTop(double hitY) {
        return hitY > 0.5;
    }

    protected boolean hitLeft(Direction side, double hitX, double hitZ) {
        switch (side) {
            case NORTH: {
                return hitX > 0.5;
            }
            case SOUTH: {
                return hitX < 0.5;
            }
            case WEST: {
                return hitZ < 0.5;
            }
            case EAST: {
                return hitZ > 0.5;
            }
        }
        return true;
    }

    protected BlockRayTraceResult rayTraceEyes(World world, PlayerEntity player, double length) {
        Vec3d eyePos = player.func_174824_e(1.0f);
        Vec3d lookPos = player.func_70676_i(1.0f);
        Vec3d endPos = eyePos.func_72441_c(lookPos.field_72450_a * length, lookPos.field_72448_b * length, lookPos.field_72449_c * length);
        RayTraceContext context = new RayTraceContext(eyePos, endPos, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player);
        return world.func_217299_a(context);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn) {
        BlockRayTraceResult rayResult;
        if (worldIn.field_72995_K) {
            return;
        }
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info("onBlockClicked");
        }
        if ((rayResult = this.rayTraceEyes(worldIn, playerIn, playerIn.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e() + 1.0)).func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        Direction side = rayResult.func_216354_b();
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(worldIn, pos);
        if (state.func_177229_b((IProperty)field_185512_D) != rayResult.func_216354_b()) {
            return;
        }
        int slot = this.getDrawerSlot(rayResult);
        IDrawer drawer = tileDrawers.getDrawer(slot);
        boolean invertShift = false;
        ItemStack item = playerIn.func_225608_bj_() != invertShift ? tileDrawers.takeItemsFromSlot(slot, drawer.getStoredItemStackSize()) : tileDrawers.takeItemsFromSlot(slot, 1);
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info(item.func_190926_b() ? "  null item" : "  " + item.toString());
        }
        if (!item.func_190926_b()) {
            if (!playerIn.field_71071_by.func_70441_a(item)) {
                this.dropItemStack(worldIn, pos.func_177972_a(side), playerIn, item);
                worldIn.func_184138_a(pos, state, state, 3);
            } else {
                worldIn.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    private void dropItemStack(World world, BlockPos pos, PlayerEntity player, @Nonnull ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.3f), (double)((float)pos.func_177952_p() + 0.5f), stack);
        Vec3d motion = entity.func_213322_ci();
        entity.func_70024_g(-motion.field_72450_a, -motion.field_72448_b, -motion.field_72449_c);
        world.func_217376_c((Entity)entity);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityDrawers tile = this.getTileEntity((IBlockReader)world, pos);
        if (tile != null) {
            // empty if block
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        if (player.func_184812_l_()) {
            if (this.creativeCanBreakBlock(state, world, pos, player)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
            } else {
                this.func_196270_a(state, world, pos, player);
            }
            return false;
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false, fluid);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_217377_a(pos, false);
    }

    public boolean creativeCanBreakBlock(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        double blockReachDistance = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e() + 1.0;
        BlockRayTraceResult rayResult = this.rayTraceEyes(world, player, blockReachDistance + 1.0);
        return rayResult.func_216346_c() == RayTraceResult.Type.MISS || state.func_177229_b((IProperty)field_185512_D) != rayResult.func_216354_b();
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getMainDrop(state, (TileEntityDrawers)builder.func_216019_b(LootParameters.field_216288_h)));
        return items;
    }

    protected ItemStack getMainDrop(BlockState state, TileEntityDrawers tile) {
        int i;
        ItemStack drop = new ItemStack((IItemProvider)this);
        if (tile == null) {
            return drop;
        }
        CompoundNBT data = drop.func_77978_p();
        if (data == null) {
            data = new CompoundNBT();
        }
        boolean hasContents = false;
        for (i = 0; i < tile.getGroup().getDrawerCount(); ++i) {
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (drawer == null || drawer.isEmpty()) continue;
            hasContents = true;
        }
        for (i = 0; i < tile.upgrades().getSlotCount(); ++i) {
            if (tile.upgrades().getUpgrade(i).func_190926_b()) continue;
            hasContents = true;
        }
        if (hasContents) {
            CompoundNBT tiledata = new CompoundNBT();
            tile.func_189515_b(tiledata);
            tiledata.func_82580_o("x");
            tiledata.func_82580_o("y");
            tiledata.func_82580_o("z");
            data.func_218657_a("tile", (INBT)tiledata);
            drop.func_77982_d(data);
        }
        return drop;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntityDrawers getTileEntity(IBlockReader blockAccess, BlockPos pos) {
        if (inTileLookup.get().booleanValue()) {
            return null;
        }
        inTileLookup.set(true);
        TileEntity tile = blockAccess.func_175625_s(pos);
        inTileLookup.set(false);
        return tile instanceof TileEntityDrawers ? (TileEntityDrawers)tile : null;
    }

    public TileEntityDrawers getTileEntitySafe(World world, BlockPos pos) {
        TileEntityDrawers tile = this.getTileEntity((IBlockReader)world, pos);
        if (tile == null) {
            tile = (TileEntityDrawers)this.createTileEntity(world.func_180495_p(pos), (IBlockReader)world);
            world.func_175690_a(pos, (TileEntity)tile);
        }
        return tile;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!this.func_149744_f(state)) {
            return 0;
        }
        TileEntityDrawers tile = this.getTileEntity(blockAccess, pos);
        if (tile == null || !tile.isRedstone()) {
            return 0;
        }
        return tile.getRedstoneLevel();
    }

    public int func_176211_b(BlockState state, IBlockReader worldIn, BlockPos pos, Direction side) {
        return side == Direction.UP ? this.func_180656_a(state, worldIn, pos, side) : 0;
    }
}

