/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.utils;

import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class RecipeHelper {
    private static final Field recipesField = ObfuscationReflectionHelper.findField(RecipeManager.class, (String)"field_199522_d");

    public static Map<ResourceLocation, IRecipe<?>> getRecipes(RecipeManager manager, IRecipeType<?> type) {
        Map recipeTypeMap = null;
        try {
            recipeTypeMap = (Map)recipesField.get(manager);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return (Map)recipeTypeMap.get(type);
    }

    public static boolean registerRecipe(RecipeManager manager, IRecipeType<?> type, IRecipe recipe) {
        Map recipeTypeMap = null;
        try {
            recipeTypeMap = (Map)recipesField.get(manager);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (recipeTypeMap == null) {
            return false;
        }
        Map recipes = (Map)recipeTypeMap.get(type);
        if (recipes == null) {
            return false;
        }
        recipes.put(recipe.func_199560_c(), recipe);
        return true;
    }

    public static boolean removeRecipe(RecipeManager manager, IRecipeType<?> type, String recipeId) {
        Map recipeTypeMap = null;
        try {
            recipesField.setAccessible(true);
            recipeTypeMap = (Map)recipesField.get(manager);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (recipeTypeMap == null) {
            return false;
        }
        Map recipes = (Map)recipeTypeMap.get(type);
        if (recipes == null) {
            return false;
        }
        recipes.remove(ResourceLocation.func_208304_a((String)recipeId));
        return true;
    }

    public static <T extends IRecipe<?>> IRecipeType<T> registerRecipeType(final ResourceLocation id) {
        IRecipeType type = new IRecipeType<T>(){

            public String toString() {
                return id.toString();
            }
        };
        return (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)id, (Object)type);
    }

    static {
        recipesField.setAccessible(true);
    }
}

