/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class FloodFill {
    private List<Block> ignoredBlocks = Arrays.asList(Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_150349_c, Blocks.field_185774_da, Blocks.field_150351_n, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_150355_j, Blocks.field_150357_h, Blocks.field_150377_bs);
    private int MAX_SEARCH_DEPTH = 2048;
    private int MAX_BLOCKS = 4196;
    private IWorldReader world;
    private BlockPos startingPosition;
    private Map<BlockPos, BlockState> result;
    private boolean normalized = true;

    public FloodFill(IWorldReader world, BlockPos startingPosition) {
        this.world = world;
        this.startingPosition = startingPosition;
    }

    private static Map<BlockPos, BlockState> normalizeBlockPosMap(Map<BlockPos, BlockState> input) {
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        for (BlockPos pos : input.keySet()) {
            if (pos.func_177956_o() < minY) {
                minY = pos.func_177956_o();
            }
            if (pos.func_177952_p() < minZ) {
                minZ = pos.func_177952_p();
            }
            if (pos.func_177958_n() >= minX) continue;
            minX = pos.func_177958_n();
        }
        HashMap<BlockPos, BlockState> result = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> blockInfo : input.entrySet()) {
            result.put(blockInfo.getKey().func_177982_a(-minX, -minY, -minZ), blockInfo.getValue());
        }
        return result;
    }

    public Map<BlockPos, BlockState> getConnectedBlocks() {
        this.result = new HashMap<BlockPos, BlockState>();
        this.floodFill(this.world, this.startingPosition, 0);
        if (this.normalized) {
            return FloodFill.normalizeBlockPosMap(this.result);
        }
        return this.result;
    }

    private void floodFill(IWorldReader world, BlockPos pos, int depth) {
        if (depth > this.MAX_SEARCH_DEPTH) {
            return;
        }
        if (this.result.size() > this.MAX_BLOCKS) {
            return;
        }
        if (this.result.containsKey(pos)) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state == null || state.func_177230_c() == null || state.func_177230_c().isAir(state, (IBlockReader)world, pos)) {
            return;
        }
        if (this.ignoredBlocks.contains(state.func_177230_c()) || state.func_177230_c() == Blocks.field_150377_bs) {
            return;
        }
        this.result.put(pos, state);
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    this.floodFill(world, pos.func_177982_a(x, y, z), depth + 1);
                }
            }
        }
    }
}

