/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework;

import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.WidgetContainer;
import com.davenonymous.libnonymous.gui.framework.event.CharTypedEvent;
import com.davenonymous.libnonymous.gui.framework.event.GuiDataUpdatedEvent;
import com.davenonymous.libnonymous.gui.framework.event.KeyPressedEvent;
import com.davenonymous.libnonymous.gui.framework.event.KeyReleasedEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseMoveEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseReleasedEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseScrollEvent;
import com.davenonymous.libnonymous.gui.framework.event.UpdateScreenEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;

public abstract class WidgetContainerScreen<T extends WidgetContainer>
extends ContainerScreen<T> {
    protected GUI gui;
    private int previousMouseX = Integer.MAX_VALUE;
    private int previousMouseY = Integer.MAX_VALUE;
    public boolean dataUpdated = false;

    public WidgetContainerScreen(T container, PlayerInventory inv, ITextComponent name) {
        super(container, inv, name);
        this.gui = this.createGUI();
        this.gui.setVisible(true);
    }

    protected abstract GUI createGUI();

    public void tick() {
        super.tick();
        this.gui.fireEvent(new UpdateScreenEvent());
        this.resetMousePositions();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.gui.fireEvent(new MouseClickEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        Slot slot = this.getSlotUnderMouse();
        if (this.gui.fireEvent(new MouseReleasedEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.gui.fireEvent(new KeyReleasedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.func_223281_a_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char chr, int code) {
        if (this.gui.fireEvent(new CharTypedEvent(chr, code)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.charTyped(chr, code);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.gui.fireEvent(new KeyPressedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        if (this.gui.fireEvent(new MouseScrollEvent(mouseX, mouseY, scrollAmount)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseScrolled(mouseX, mouseY, scrollAmount);
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.dataUpdated) {
            this.dataUpdated = false;
            this.gui.fireEvent(new GuiDataUpdatedEvent());
        }
        if (mouseX != this.previousMouseX || mouseY != this.previousMouseY) {
            this.gui.fireEvent(new MouseMoveEvent(mouseX, mouseY));
            this.previousMouseX = mouseX;
            this.previousMouseY = mouseY;
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(-this.field_147003_i), (float)(-this.field_147009_r + 18), (float)0.0f);
        this.gui.drawTooltips((Screen)this, mouseX, mouseY);
        this.func_191948_b(mouseX, mouseY);
        RenderSystem.popMatrix();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        this.gui.drawGUI((Screen)this);
        if (this.field_147002_h != null && ((WidgetContainer)this.field_147002_h).field_75151_b != null) {
            for (Slot slot : ((WidgetContainer)this.field_147002_h).field_75151_b) {
                if (!slot.func_111238_b()) continue;
                this.gui.drawSlot((Screen)this, slot, this.field_147003_i, this.field_147009_r);
            }
        }
    }

    protected void resetMousePositions() {
        this.previousMouseX = Integer.MIN_VALUE;
        this.previousMouseY = Integer.MIN_VALUE;
    }

    public void fireDataUpdateEvent() {
        this.dataUpdated = true;
    }
}

