/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.base;

import com.davenonymous.libnonymous.serialization.Store;
import com.davenonymous.libnonymous.serialization.nbt.NBTFieldSerializationData;
import com.davenonymous.libnonymous.serialization.nbt.NBTFieldUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class BaseTileEntity
extends TileEntity
implements ITickableTileEntity {
    private boolean initialized = false;
    @Store(storeWithItem=true, sendInUpdatePackage=true)
    protected String customName;
    @Store(storeWithItem=true, sendInUpdatePackage=true)
    protected UUID owner;
    @Store(sendInUpdatePackage=true)
    private int incomingRedstonePower = 0;
    private List<NBTFieldSerializationData> NBTActions = NBTFieldUtils.initSerializableStoreFields(((Object)((Object)this)).getClass());

    public BaseTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void loadFromItem(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTFieldUtils.readFieldsFromNBT(this.NBTActions, (Object)this, stack.func_77978_p(), data -> data.storeWithItem);
        this.func_70296_d();
    }

    public void saveToItem(ItemStack stack) {
        CompoundNBT compound = this.createItemStackTagCompound();
        stack.func_77982_d(compound);
    }

    protected CompoundNBT createItemStackTagCompound() {
        return NBTFieldUtils.writeFieldsToNBT(this.NBTActions, (Object)this, new CompoundNBT(), data -> data.storeWithItem);
    }

    public void notifyClients() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return NBTFieldUtils.writeFieldsToNBT(this.NBTActions, (Object)this, super.func_189517_E_(), data -> data.sendInUpdatePackage);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        NBTFieldUtils.readFieldsFromNBT(this.NBTActions, (Object)this, pkt.func_148857_g(), data -> data.sendInUpdatePackage);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        NBTFieldUtils.readFieldsFromNBT(this.NBTActions, (Object)this, compound, data -> true);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound = NBTFieldUtils.writeFieldsToNBT(this.NBTActions, (Object)this, compound, data -> true);
        return compound;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && !this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    protected void initialize() {
    }

    protected void spawnItem(ItemStack stack) {
        ItemEntity entityItem = new ItemEntity(this.field_145850_b, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.7f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), stack);
        entityItem.lifespan = 1200;
        entityItem.func_174867_a(5);
        entityItem.func_213293_j(0.0, (double)0.1f, 0.0);
        this.field_145850_b.func_217376_c((Entity)entityItem);
    }

    public void redstonePulse() {
    }

    public void redstoneChanged(int previous, int now) {
    }

    public int getRedstonePowerFromNeighbors() {
        return this.field_145850_b.func_175687_A(this.field_174879_c);
    }

    public int getIncomingRedstonePower() {
        return this.incomingRedstonePower;
    }

    public BaseTileEntity setIncomingRedstonePower(int incomingRedstonePower) {
        this.incomingRedstonePower = incomingRedstonePower;
        return this;
    }

    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        return this.field_145850_b.func_73046_m().func_152358_ax().func_152652_a(this.getOwner()).getName();
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setOwner(PlayerEntity player) {
        if (player == null) {
            return;
        }
        this.setOwner(player.func_110124_au());
    }

    public boolean isWaterlogged() {
        if (!this.field_145850_b.func_180495_p(this.func_174877_v()).func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
            return false;
        }
        return (Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockStateProperties.field_208198_y);
    }
}

