/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.world.template;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Dynamic;
import com.stal111.valhelsia_structures.world.template.Processors;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.template.JigsawReplacementStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class ValhelsiaSingleJigsawPiece
extends SingleJigsawPiece {
    public static IJigsawDeserializer VALHELSIA_SINGLE_POOL_ELEMENT = IJigsawDeserializer.func_214926_a((String)"valhelsia_single_pool_element", ValhelsiaSingleJigsawPiece::new);

    public ValhelsiaSingleJigsawPiece(String location) {
        this(location, (List<StructureProcessor>)ImmutableList.of());
    }

    public ValhelsiaSingleJigsawPiece(String location, List<StructureProcessor> processors) {
        this(location, processors, JigsawPattern.PlacementBehaviour.RIGID);
    }

    public ValhelsiaSingleJigsawPiece(String location, List<StructureProcessor> processors, JigsawPattern.PlacementBehaviour placementBehaviour) {
        super(location, processors, placementBehaviour);
    }

    public ValhelsiaSingleJigsawPiece(Dynamic<?> dynamic) {
        super(dynamic);
    }

    public boolean func_225575_a_(TemplateManager templateManager, @Nonnull IWorld world, ChunkGenerator<?> generator, @Nonnull BlockPos position, @Nonnull Rotation rotation, @Nonnull MutableBoundingBox bounds, @Nonnull Random random) {
        PlacementSettings placementSettings;
        Template template = templateManager.func_200220_a(this.field_214861_a);
        if (!template.func_189962_a(world, position, placementSettings = this.func_214860_a(rotation, bounds), 18)) {
            return false;
        }
        for (Template.BlockInfo blockInfo : Template.processBlockInfos((Template)template, (IWorld)world, (BlockPos)position, (PlacementSettings)placementSettings, (List)this.func_214857_a(templateManager, position, rotation, false))) {
            this.func_214846_a(world, blockInfo, position, rotation, random, bounds);
        }
        return true;
    }

    @Nonnull
    protected PlacementSettings func_214860_a(@Nonnull Rotation rotation, @Nonnull MutableBoundingBox bounds) {
        PlacementSettings placementSettings = new PlacementSettings();
        placementSettings.func_186223_a(bounds);
        placementSettings.func_186220_a(rotation);
        placementSettings.func_215223_c(true);
        placementSettings.func_186222_a(false);
        placementSettings.func_215222_a((StructureProcessor)Processors.RED_GLASS_AND_STRUCTURE_BLOCK);
        placementSettings.func_215222_a((StructureProcessor)JigsawReplacementStructureProcessor.field_215196_a);
        placementSettings.func_215222_a((StructureProcessor)Processors.OBSIDIAN_REPLACEMENT_PROCESSOR);
        placementSettings.func_215222_a((StructureProcessor)Processors.STONE_REPLACEMENT_PROCESSOR);
        this.field_214862_b.forEach(arg_0 -> ((PlacementSettings)placementSettings).func_215222_a(arg_0));
        this.func_214854_c().func_214937_b().forEach(arg_0 -> ((PlacementSettings)placementSettings).func_215222_a(arg_0));
        return placementSettings;
    }

    @Nonnull
    public IJigsawDeserializer func_214853_a() {
        return VALHELSIA_SINGLE_POOL_ELEMENT;
    }
}

