/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.recipe;

import com.google.common.collect.ImmutableMap;
import com.stal111.valhelsia_structures.init.ModBlocks;
import com.stal111.valhelsia_structures.init.ModRecipes;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AxeCraftingRecipe
extends SpecialRecipe {
    protected static Map<Block, Block> LOG_POST_MAP = null;
    public static final IRecipeType<AxeCraftingRecipe> RECIPE_TYPE = new IRecipeType<AxeCraftingRecipe>(){

        public String toString() {
            return "valhelsia_structures:axe_crafting";
        }
    };

    public AxeCraftingRecipe(ResourceLocation idIn) {
        super(idIn);
        LOG_POST_MAP = new ImmutableMap.Builder().put((Object)Blocks.field_196617_K, (Object)ModBlocks.OAK_POST.get()).put((Object)Blocks.field_196618_L, (Object)ModBlocks.SPRUCE_POST.get()).put((Object)Blocks.field_196619_M, (Object)ModBlocks.BIRCH_POST.get()).put((Object)Blocks.field_196620_N, (Object)ModBlocks.JUNGLE_POST.get()).put((Object)Blocks.field_196621_O, (Object)ModBlocks.ACACIA_POST.get()).put((Object)Blocks.field_196623_P, (Object)ModBlocks.DARK_OAK_POST.get()).build();
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        int axeSlot = -1;
        Block block = null;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            if (!(inv.func_70301_a(slot).func_77973_b() instanceof AxeItem)) continue;
            axeSlot = slot;
            break;
        }
        if (axeSlot == -1) {
            return false;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (i == axeSlot || stack.func_190926_b()) continue;
            if (this.isValidBlock(stack) && (block == null || Block.func_149634_a((Item)stack.func_77973_b()) == block)) {
                block = Block.func_149634_a((Item)stack.func_77973_b());
                continue;
            }
            return false;
        }
        return block != null;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        Block block = null;
        int logCount = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!this.isValidBlock(stack)) continue;
            block = Block.func_149634_a((Item)stack.func_77973_b());
            ++logCount;
        }
        return new ItemStack((IItemProvider)LOG_POST_MAP.get(block), logCount * 2);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        int i;
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        int logCount = 0;
        for (i = 0; i < nonnulllist.size(); ++i) {
            if (!this.isValidBlock(inv.func_70301_a(i))) continue;
            ++logCount;
        }
        for (i = 0; i < nonnulllist.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof AxeItem)) continue;
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_196085_b(stack1.func_77952_i() + logCount);
            if (stack1.func_77952_i() >= stack1.func_77958_k()) continue;
            nonnulllist.set(i, (Object)stack1);
        }
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.AXE_CRAFTING_SERIALIZER.get();
    }

    private boolean isValidBlock(ItemStack stack) {
        return LOG_POST_MAP.containsKey(Block.func_149634_a((Item)stack.func_77973_b()));
    }
}

