/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.RenderableTextComponent;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.TaggableList;
import mcp.mobius.waila.api.impl.TaggedTextComponent;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.overlay.RayTracing;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class Tooltip {
    private final Minecraft client;
    private final List<Line> lines;
    private final boolean showItem;
    private final Dimension totalSize;

    public Tooltip(List<ITextComponent> components, boolean showItem) {
        WailaTooltipEvent event = new WailaTooltipEvent(components, DataAccessor.INSTANCE);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.client = Minecraft.func_71410_x();
        this.lines = Lists.newArrayList();
        this.showItem = showItem;
        this.totalSize = new Dimension();
        this.computeLines(components);
        this.addPadding();
    }

    public void computeLines(List<ITextComponent> components) {
        components.forEach(c -> {
            Dimension size = this.getLineSize((ITextComponent)c, components);
            this.totalSize.setSize(Math.max(this.totalSize.width, size.width), this.totalSize.height + size.height);
            ITextComponent component = c;
            if (component instanceof TaggedTextComponent) {
                component = (ITextComponent)((ITaggableList)components).getTag(((TaggedTextComponent)component).getTag());
            }
            this.lines.add(new Line(component, size));
        });
    }

    public void addPadding() {
        this.totalSize.width = this.totalSize.width + (this.hasItem() ? 30 : 10);
        this.totalSize.height += 8;
    }

    public void draw() {
        Rectangle position = this.getPosition();
        WailaConfig.ConfigOverlay.ConfigOverlayColor color = Waila.CONFIG.get().getOverlay().getColor();
        position.x = position.x + (this.hasItem() ? 26 : 6);
        position.width = position.width + (this.hasItem() ? 24 : 4);
        position.y += 6;
        for (Line line : this.lines) {
            if (line.getComponent() instanceof RenderableTextComponent) {
                RenderableTextComponent component = (RenderableTextComponent)line.getComponent();
                int xOffset = 0;
                for (RenderableTextComponent.RenderContainer container : component.getRenderers()) {
                    Dimension size = container.getRenderer().getSize(container.getData(), DataAccessor.INSTANCE);
                    container.getRenderer().draw(container.getData(), DataAccessor.INSTANCE, position.x + xOffset, position.y);
                    xOffset += size.width;
                }
            } else {
                this.client.field_71466_p.func_175063_a(line.getComponent().func_150254_d(), (float)position.x, (float)position.y, color.getFontColor());
            }
            position.y += ((Line)line).size.height;
        }
    }

    private Dimension getLineSize(ITextComponent component, List<ITextComponent> components) {
        if (component instanceof RenderableTextComponent) {
            RenderableTextComponent renderable = (RenderableTextComponent)component;
            List<RenderableTextComponent.RenderContainer> renderers = renderable.getRenderers();
            if (renderers.isEmpty()) {
                return new Dimension(0, 0);
            }
            int width = 0;
            int height = 0;
            for (RenderableTextComponent.RenderContainer container : renderers) {
                Dimension iconSize = container.getRenderer().getSize(container.getData(), DataAccessor.INSTANCE);
                width += iconSize.width;
                height = Math.max(height, iconSize.height);
            }
            return new Dimension(width, height);
        }
        if (component instanceof TaggedTextComponent) {
            TaggedTextComponent tagged = (TaggedTextComponent)component;
            if (components instanceof TaggableList) {
                ITextComponent taggedLine = (ITextComponent)((TaggableList)components).getTag(tagged.getTag());
                return taggedLine == null ? new Dimension(0, 0) : this.getLineSize(taggedLine, components);
            }
        }
        int n = this.client.field_71466_p.func_78256_a(component.func_150254_d());
        this.client.field_71466_p.getClass();
        return new Dimension(n, 9 + 1);
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public boolean hasItem() {
        return this.showItem && Waila.CONFIG.get().getGeneral().shouldShowItem() && !RayTracing.INSTANCE.getIdentifierStack().func_190926_b();
    }

    public Rectangle getPosition() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        return new Rectangle((int)((float)window.func_198107_o() * Waila.CONFIG.get().getOverlay().getOverlayPosX() - (float)(this.totalSize.width / 2)), (int)((float)window.func_198087_p() * (1.0f - Waila.CONFIG.get().getOverlay().getOverlayPosY())), this.totalSize.width, this.totalSize.height);
    }

    public static class Line {
        private final ITextComponent component;
        private final Dimension size;

        public Line(ITextComponent component, Dimension size) {
            this.component = component;
            this.size = size;
        }

        public ITextComponent getComponent() {
            return this.component;
        }

        public Dimension getSize() {
            return this.size;
        }
    }
}

