/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import mcp.mobius.waila.gui.config.OptionsListWidget;
import mcp.mobius.waila.gui.config.value.OptionsEntryValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;

public abstract class GuiOptions
extends Screen {
    private final Screen parent;
    private final Runnable saver;
    private final Runnable canceller;
    private OptionsListWidget options;

    public GuiOptions(Screen parent, TextComponent title, Runnable saver, Runnable canceller) {
        super((ITextComponent)title);
        this.parent = parent;
        this.saver = saver;
        this.canceller = canceller;
    }

    public GuiOptions(Screen parent, TextComponent title) {
        this(parent, title, null, null);
    }

    public void init(Minecraft client, int width, int height) {
        super.init(client, width, height);
        this.options = this.getOptions();
        this.children.add(this.options);
        this.setFocused((IGuiEventListener)this.options);
        if (this.saver != null && this.canceller != null) {
            this.addButton((Widget)new Button(width / 2 - 100, height - 25, 100, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), w -> {
                this.options.save();
                this.saver.run();
                this.onClose();
            }));
            this.addButton((Widget)new Button(width / 2 + 5, height - 25, 100, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), w -> {
                this.canceller.run();
                this.onClose();
            }));
        } else {
            this.addButton((Widget)new Button(width / 2 - 50, height - 25, 100, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), w -> {
                this.options.save();
                this.onClose();
            }));
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        OptionsEntryValue value;
        this.renderBackground();
        this.options.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 12, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
        if (mouseY < 32 || mouseY > this.height - 32) {
            return;
        }
        OptionsListWidget.Entry entry = (OptionsListWidget.Entry)this.options.getSelected();
        if (entry instanceof OptionsEntryValue && I18n.func_188566_a((String)(value = (OptionsEntryValue)entry).getDescription())) {
            int valueX = value.getX() + 10;
            String title = value.getTitle().func_150254_d();
            if (mouseX < valueX || mouseX > valueX + this.font.func_78256_a(title)) {
                return;
            }
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{title});
            tooltip.addAll(this.font.func_78271_c(I18n.func_135052_a((String)value.getDescription(), (Object[])new Object[0]), 200));
            this.renderTooltip(tooltip, mouseX, mouseY);
        }
    }

    public void onClose() {
        this.minecraft.func_147108_a(this.parent);
    }

    public void addListener(IGuiEventListener listener) {
        this.children.add(listener);
    }

    public abstract OptionsListWidget getOptions();
}

