/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import journeymap.common.CommonProxy;
import journeymap.common.Journeymap;
import journeymap.common.version.Version;
import journeymap.server.Constants;
import journeymap.server.events.ForgeEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.OpEntry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

public class JourneymapServer
implements CommonProxy {
    private Logger logger = Journeymap.getLogger();
    public static boolean DEV_MODE = false;
    private static final Version MINIMUM_ACCEPTABLE_VERSION = new Version(5, 5, 6);

    @Override
    public void commonSetupEvent(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEvents());
    }

    @Override
    public void loadCompleteEvent(FMLLoadCompleteEvent event) {
    }

    @Override
    public void imcHandle(InterModProcessEvent event) {
    }

    @Override
    public void clientSetupEvent(FMLClientSetupEvent event) {
    }

    @Override
    public void imcEnqueue(InterModEnqueueEvent event) {
    }

    @Override
    public void dedicatedServerSetupEvent(FMLDedicatedServerSetupEvent event) {
    }

    @Override
    public boolean isUpdateCheckEnabled() {
        return false;
    }

    public static boolean isOp(PlayerEntity player) {
        if (LogicalSide.CLIENT.equals((Object)EffectiveSide.get())) {
            MinecraftServer mcServer = ServerLifecycleHooks.getCurrentServer();
            boolean creative = player.field_71075_bZ.field_75098_d;
            boolean cheatMode = mcServer.func_184103_al().func_152596_g(new GameProfile(player.func_110124_au(), player.func_200200_C_().func_150254_d()));
            return creative || cheatMode;
        }
        List<String> opNames = Arrays.asList(ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152606_n());
        List opIds = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152603_m().func_199043_f().stream().map(JourneymapServer::getValidOpId).filter(Objects::nonNull).collect(Collectors.toList());
        return opNames.contains(player.func_145748_c_().func_150254_d()) || opIds.contains(player.func_110124_au()) || Constants.debugOverride((Entity)player);
    }

    private static UUID getValidOpId(OpEntry entry) {
        if (entry.func_152640_f() != null) {
            return ((GameProfile)entry.func_152640_f()).getId();
        }
        return null;
    }
}

