/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.util;

import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidUtil
implements IFluidHandlerItem {
    private ItemStack container;
    private int capacity;
    private FluidStack fluid;

    public FluidUtil(ItemStack container, int capacity, FluidStack fluid) {
        this.container = container;
        this.capacity = capacity;
        this.fluid = fluid;
    }

    public FluidUtil(ItemStack container, int capacity, Fluid fluid) {
        this.container = container;
        this.capacity = capacity;
        this.fluid = new FluidStack(fluid, capacity);
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public int getTanks() {
        return 0;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return !stack.isEmpty();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return null;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.func_190916_E() != 1 || maxDrain <= 0) {
            return null;
        }
        if (this.fluid == null || this.fluid.getAmount() <= 0) {
            return null;
        }
        int drainAmount = Math.min(this.fluid.getAmount(), maxDrain);
        FluidStack drained = this.fluid.copy();
        drained.setAmount(drainAmount);
        return drained;
    }
}

