/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.tiles;

import com.kashdeya.tinyprogressions.capabilities.InventoryStorage;
import com.kashdeya.tinyprogressions.inits.ModTileEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityCobblegen
extends TileEntity
implements ITickableTileEntity {
    int cycle = 0;
    int cycleUpdate = 40;
    int maxStacksize = 32;
    public LazyOptional<InventoryStorage> outputInventory = LazyOptional.of(() -> new InventoryStorage(1){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return false;
        }

        @Override
        public void writeToNBT(CompoundNBT compound) {
            compound.func_218657_a("outputInventory", (INBT)this.serializeNBT());
        }

        @Override
        public void readFromNBT(CompoundNBT compound) {
            this.deserializeNBT(compound.func_74775_l("outputInventory"));
        }
    });

    public TileEntityCobblegen() {
        super((TileEntityType)ModTileEntityTypes.CobbleGen.get());
    }

    public TileEntityCobblegen setGenStats(int cycleUpdate, int maxStackSize) {
        this.cycleUpdate = cycleUpdate;
        this.maxStacksize = maxStackSize;
        return this;
    }

    public int getCycleUpdate() {
        return this.cycleUpdate;
    }

    public int getMaxStackSize() {
        return this.maxStacksize;
    }

    public ItemStack getStack() {
        InventoryStorage inventory = (InventoryStorage)((Object)this.outputInventory.orElse(null));
        return inventory == null ? ItemStack.field_190927_a : inventory.getStackInSlot(0);
    }

    public boolean hasStorage() {
        return this.outputInventory.orElse(null) != null;
    }

    public InventoryStorage getInventory() {
        return (InventoryStorage)((Object)this.outputInventory.orElse(null));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.cycle;
        if (this.cycle >= this.getCycleUpdate()) {
            this.cycle = 0;
            if (this.getStack() == ItemStack.field_190927_a || this.getStack().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150347_e)) {
                this.getInventory().setStackInSlot(0, new ItemStack((IItemProvider)Blocks.field_150347_e));
            } else {
                this.getStack().func_190920_e(Math.min(this.getMaxStackSize(), this.getStack().func_190916_E() + 1));
            }
            this.getInventory().setStackInSlot(0, this.getStack());
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(Direction.UP));
            if (tile != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).isPresent()) {
                IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).orElse(null);
                if (this.getInventory().getStackInSlot(0) != ItemStack.field_190927_a) {
                    ItemStack stack = this.getInventory().getStackInSlot(0).func_77946_l();
                    stack.func_190920_e(1);
                    ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
                    if (stack1 == ItemStack.field_190927_a || stack1.func_190916_E() == 0) {
                        ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)this.getInventory().extractItemInternal(0, 1, false), (boolean)false);
                        this.func_70296_d();
                    }
                }
            } else if (tile instanceof IInventory) {
                IInventory iinventory = (IInventory)tile;
                if (this.isInventoryFull(iinventory, Direction.UP)) {
                    return;
                }
                if (this.getInventory().getStackInSlot(0) != ItemStack.field_190927_a) {
                    ItemStack stack = this.getInventory().getStackInSlot(0).func_77946_l();
                    ItemStack stack1 = TileEntityCobblegen.putStackInInventoryAllSlots(iinventory, this.getInventory().extractItemInternal(0, 1, false), Direction.UP);
                    if (stack1 == ItemStack.field_190927_a || stack1.func_190916_E() == 0) {
                        iinventory.func_70296_d();
                    } else {
                        this.getInventory().setStackInSlot(0, stack);
                    }
                }
            }
            this.func_70296_d();
        }
    }

    protected boolean isInventoryFull(IInventory inventoryIn, Direction side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int k : aint = isidedinventory.func_180463_a(side)) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(k);
                if (itemstack1 != ItemStack.field_190927_a && itemstack1.func_190916_E() == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.func_70301_a(j);
                if (itemstack != ItemStack.field_190927_a && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inventoryIn, ItemStack stack, @Nullable Direction side) {
        if (inventoryIn instanceof ISidedInventory && side != null && !(inventoryIn instanceof TileEntityCobblegen) && inventoryIn.func_94041_b(0, stack.func_77946_l())) {
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            int[] aint = isidedinventory.func_180463_a(side);
            for (int k = 0; k < aint.length && stack != ItemStack.field_190927_a && stack.func_190916_E() > 0; ++k) {
                stack = TileEntityCobblegen.insertStack(inventoryIn, stack, aint[k], side);
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i && stack != ItemStack.field_190927_a && stack.func_190916_E() > 0; ++j) {
                stack = TileEntityCobblegen.insertStack(inventoryIn, stack, j, side);
            }
        }
        if (stack != ItemStack.field_190927_a && stack.func_190916_E() == 0) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }

    private static ItemStack insertStack(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (TileEntityCobblegen.canInsertItemInSlot(inventoryIn, stack, index, side)) {
            int max;
            if (itemstack == ItemStack.field_190927_a) {
                int max2 = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_());
                if (max2 >= stack.func_190916_E()) {
                    inventoryIn.func_70299_a(index, stack);
                    stack = ItemStack.field_190927_a;
                } else {
                    inventoryIn.func_70299_a(index, stack.func_77979_a(max2));
                }
            } else if (TileEntityCobblegen.canCombine(itemstack, stack) && (max = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_())) > itemstack.func_190916_E()) {
                int i = max - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190920_e(stack.func_190916_E() - j);
                itemstack.func_190920_e(itemstack.func_190916_E() + j);
            }
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        return inventoryIn.func_94041_b(index, stack) && (!(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side));
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.outputInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("maxStackSize", this.maxStacksize);
        compound.func_74768_a("cycleUpdate", this.cycleUpdate);
        compound.func_74768_a("cycle", this.cycle);
        return compound;
    }

    public void func_145839_a(@Nonnull CompoundNBT compound) {
        super.func_145839_a(compound);
        this.maxStacksize = compound.func_74762_e("maxStackSize");
        this.cycleUpdate = compound.func_74762_e("cycleUpdate");
        this.cycle = compound.func_74762_e("cycle");
    }
}

