/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kashdeya.tinyprogressions.recipes.ArmorRecipes;
import com.kashdeya.tinyprogressions.recipes.BlockRecipes;
import com.kashdeya.tinyprogressions.recipes.FoodRecipes;
import com.kashdeya.tinyprogressions.recipes.ItemRecipes;
import com.kashdeya.tinyprogressions.recipes.OtherRecipes;
import com.kashdeya.tinyprogressions.recipes.ToolsRecipes;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class exportJson {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File RECIPE_DIR = null;
    private static final Set<String> USED_OD_NAMES = new TreeSet<String>();

    public static void init() {
        ArmorRecipes.init();
        BlockRecipes.init();
        FoodRecipes.init();
        ItemRecipes.init();
        OtherRecipes.init();
        ToolsRecipes.init();
    }

    private static void setupDir() {
        if (RECIPE_DIR == null) {
            RECIPE_DIR = new File("E:/Minecraft Modding/1.14.x Workspace All Mods/TinyProgressions/Tiny-Progressions/run/config/tp/recipes/");
        }
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
    }

    public static void addShapedRecipe(ItemStack result, Object ... components) {
        int i;
        exportJson.setupDir();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add(((String)components[i]).toUpperCase());
        }
        boolean isOreDict = false;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object o = components[i];
            if (o instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)o;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (o instanceof String) {
                    isOreDict = true;
                }
                key.put(Character.toString(Character.toUpperCase(curKey.charValue())), exportJson.serializeItem(o));
                curKey = null;
            }
            ++i;
        }
        json.put("type", "minecraft:crafting_shaped");
        json.put("pattern", pattern);
        json.put("key", key);
        json.put("result", exportJson.serializeItem(result));
        String suffix = "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapedNBTRecipe(ItemStack result, Object ... components) {
        int i;
        exportJson.setupDir();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add(((String)components[i]).toUpperCase());
        }
        boolean isOreDict = false;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object o = components[i];
            if (o instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)o;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (o instanceof String) {
                    isOreDict = true;
                }
                key.put(Character.toString(Character.toUpperCase(curKey.charValue())), exportJson.serializeItem(o, true));
                curKey = null;
            }
            ++i;
        }
        json.put("type", "tp:crafting_shaped_nbt");
        json.put("pattern", pattern);
        json.put("key", key);
        json.put("result", exportJson.serializeItem(result, true));
        String suffix = "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addSmeltingRecipe(ItemStack result, int experience, int cookingtime, Object ... components) {
        exportJson.setupDir();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object o : components) {
            if (o instanceof String) {
                isOreDict = true;
            }
            ingredients.add(exportJson.serializeItem(o));
        }
        json.put("type", "minecraft:smelting");
        json.put("ingredient", ingredients);
        json.put("result", exportJson.serializeItem(result));
        json.put("experience", experience);
        if (cookingtime != 200) {
            json.put("cookingtime", "minecraft:smelting");
        }
        String suffix = "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + "_smelting.json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + "_smelting" + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapelessRecipe(ItemStack result, Object ... components) {
        exportJson.setupDir();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object o : components) {
            if (o instanceof String) {
                isOreDict = true;
            }
            ingredients.add(exportJson.serializeItem(o));
        }
        json.put("type", "minecraft:crafting_shapeless");
        json.put("ingredients", ingredients);
        json.put("result", exportJson.serializeItem(result));
        String suffix = "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Object> serializeItem(Object thing) {
        return exportJson.serializeItem(thing, false);
    }

    private static Map<String, Object> serializeItem(Object thing, boolean isNBT) {
        if (thing instanceof Item) {
            return exportJson.serializeItem(new ItemStack((IItemProvider)((Item)thing)));
        }
        if (thing instanceof Block) {
            return exportJson.serializeItem(new ItemStack((IItemProvider)((Block)thing)));
        }
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (isNBT && stack.func_77942_o() && !stack.func_77978_p().isEmpty()) {
                ret.put("nbt", stack.func_77978_p().toString());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            return ret;
        }
        if (thing instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            USED_OD_NAMES.add((String)thing);
            ret.put("tag", (String)thing);
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    private static void generateConstants() {
        ArrayList json = new ArrayList();
        for (String s : USED_OD_NAMES) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", s.toUpperCase(Locale.ROOT));
            entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)s));
            json.add(entry);
        }
        try (FileWriter w = new FileWriter(new File(RECIPE_DIR, "_constants.json"));){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

