/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.items.wateringcan;

import com.kashdeya.tinyprogressions.inits.TechItems;
import com.kashdeya.tinyprogressions.items.ItemBase;
import com.kashdeya.tinyprogressions.util.CanUtil;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class WateringCanBase
extends ItemBase {
    private int range = 1;
    private int waterChance = 100;
    private boolean canWater = false;
    private boolean showParticlTicks = false;
    private boolean forceActive = false;
    private long ticksInUse;
    int clicks = 0;

    public WateringCanBase(Item.Properties prop) {
        super(prop.func_200917_a(1));
    }

    public WateringCanBase setWateringRange(int newRange) {
        this.range = newRange;
        return this;
    }

    public WateringCanBase setWateringChance(int newChance) {
        this.waterChance = newChance;
        return this;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ++this.ticksInUse;
        if (this.ticksInUse % 4L == 0L) {
            this.showParticlTicks = true;
            this.canWater = true;
        }
        if (this.forceActive && entityIn instanceof PlayerEntity) {
            RayTraceResult raytrace;
            ItemStack offhand;
            PlayerEntity player = (PlayerEntity)entityIn;
            if (!isSelected && (offhand = player.func_184586_b(Hand.OFF_HAND)).func_77973_b() != TechItems.watering_can.get() && offhand.func_77973_b() != TechItems.watering_can_upgrade.get()) {
                this.forceActive = false;
            }
            if ((raytrace = WateringCanBase.func_219968_a((World)worldIn, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE)) != null && raytrace.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytrace;
                this.attemptWaterParticles(worldIn, blockraytraceresult.func_216350_a());
                this.attemptWater(worldIn, blockraytraceresult.func_216350_a());
            }
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.func_77636_d(stack) ? Rarity.UNCOMMON : Rarity.COMMON;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.forceActive;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        Hand hand = context.func_221531_n();
        Direction facing = context.func_196000_l();
        if (!world.field_72995_K && player.func_213453_ef()) {
            int wateringcanCount = (int)IntStream.range(0, player.field_71071_by.func_70302_i_()).mapToObj(i -> player.field_71071_by.func_70301_a(i)).filter(itemstack -> itemstack != ItemStack.field_190927_a).map(ItemStack::func_77973_b).filter(item -> item == TechItems.watering_can.get() || item == TechItems.watering_can_upgrade.get()).count();
            if (wateringcanCount <= 1) {
                if (wateringcanCount == 1) {
                    this.forceActive = !this.forceActive;
                }
                return ActionResultType.FAIL;
            }
            this.forceActive = false;
            player.func_145747_a((ITextComponent)new TranslationTextComponent("item.watering_can.invalidusage", new Object[0]));
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, player.func_184586_b(hand))) {
            return ActionResultType.FAIL;
        }
        this.attemptWaterParticles(world, pos);
        return this.attemptWater(world, pos);
    }

    private ActionResultType attemptWater(World world, BlockPos pos) {
        if (!world.field_72995_K && this.canWater) {
            this.canWater = false;
            int chance = CanUtil.randInt(1, 100);
            if (chance <= this.waterChance) {
                for (int xAxis = -this.range; xAxis <= this.range; ++xAxis) {
                    for (int zAxis = -this.range; zAxis <= this.range; ++zAxis) {
                        for (int yAxis = -this.range; yAxis <= this.range; ++yAxis) {
                            BlockState checkBlock = world.func_180495_p(pos.func_177982_a(xAxis, yAxis, zAxis));
                            if (!(checkBlock.func_177230_c() instanceof IGrowable) && checkBlock.func_177230_c() != Blocks.field_150391_bh && checkBlock.func_177230_c() != Blocks.field_150434_aF && checkBlock.func_177230_c() != Blocks.field_196608_cF && checkBlock.func_177230_c() != Blocks.field_185766_cS) continue;
                            if (checkBlock.func_177230_c() instanceof CropsBlock) {
                                checkBlock.func_177230_c().func_225534_a_(checkBlock, (ServerWorld)world, pos.func_177982_a(xAxis, yAxis, zAxis), world.field_73012_v);
                                continue;
                            }
                            world.func_184138_a(pos.func_177982_a(xAxis, yAxis, zAxis), checkBlock, checkBlock, 2);
                        }
                    }
                }
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.FAIL;
    }

    private void attemptWaterParticles(World world, BlockPos pos) {
        if (this.showParticlTicks) {
            this.showParticlTicks = false;
            Random rand = new Random();
            for (int x = -this.range; x <= this.range; ++x) {
                for (int z = -this.range; z <= this.range; ++z) {
                    double d0 = (float)pos.func_177982_a(x, 0, z).func_177958_n() + rand.nextFloat();
                    double d1 = (double)pos.func_177982_a(x, 0, z).func_177956_o() + 1.0;
                    double d2 = (float)pos.func_177982_a(x, 0, z).func_177952_p() + rand.nextFloat();
                    BlockState checkSolidState = world.func_180495_p(pos);
                    Block checkSolid = checkSolidState.func_177230_c();
                    if (checkSolid.func_220081_d(checkSolidState, (IBlockReader)world, pos) || checkSolid instanceof FarmlandBlock) {
                        d1 += 1.0;
                    }
                    world.func_195594_a((IParticleData)ParticleTypes.field_197600_K, d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static boolean applyBonemeal(ItemStack stack, World worldIn, BlockPos target, PlayerEntity player, Hand hand) {
        IGrowable igrowable;
        BlockState iblockstate = worldIn.func_180495_p(target);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)worldIn, (BlockPos)target, (BlockState)iblockstate, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        if (iblockstate.func_177230_c() instanceof IGrowable && iblockstate.func_177230_c() != Blocks.field_150349_c && (igrowable = (IGrowable)iblockstate.func_177230_c()).func_176473_a((IBlockReader)worldIn, target, iblockstate, worldIn.field_72995_K)) {
            if (!worldIn.field_72995_K) {
                if (igrowable.func_180670_a(worldIn, worldIn.field_73012_v, target, iblockstate)) {
                    igrowable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, target, iblockstate);
                }
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77973_b() == TechItems.watering_can.get()) {
            tooltip.add(new TranslationTextComponent("tooltip.can_1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            tooltip.add(new TranslationTextComponent("tooltip.can_1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            tooltip.add(new TranslationTextComponent("tooltip.can_1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        } else {
            tooltip.add(new TranslationTextComponent("tooltip.canupgrade_1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            tooltip.add(new TranslationTextComponent("tooltip.canupgrade_2", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            tooltip.add(new TranslationTextComponent("tooltip.canupgrade_3", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        }
    }
}

