/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.inits;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.kashdeya.tinyprogressions.handlers.ConfigHandler;
import com.kashdeya.tinyprogressions.inits.TechBlocks;
import com.kashdeya.tinyprogressions.main.TinyProgressions;
import com.kashdeya.tinyprogressions.world.QuickSandFeature;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TechFeatures {
    public static RegistryObject<Feature<BlockStateFeatureConfig>> QuickSandFeature = TinyProgressions.FEATURES.register("quicksandfeature", () -> new QuickSandFeature(BlockStateFeatureConfig::func_227271_a_));
    public static BlockClusterFeatureConfig blackBerryBushConfigFeature;
    public static BlockClusterFeatureConfig blueBerryBushConfigFeature;
    public static BlockClusterFeatureConfig maloBerryBushConfigFeature;
    public static BlockClusterFeatureConfig raspBerryBushConfigFeature;
    public static BlockClusterFeatureConfig reedConfigFeature;
    public static final List<Biome.Category> berryWhitelist;
    public static final List<Biome.Category> reedWhitelist;

    public static void registerAllFeatures() {
        blackBerryBushConfigFeature = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)TechBlocks.blackberry_bush.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i.func_176223_P().func_177230_c())).func_227317_b_().func_227322_d_();
        blueBerryBushConfigFeature = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)TechBlocks.blueberry_bush.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i.func_176223_P().func_177230_c())).func_227317_b_().func_227322_d_();
        maloBerryBushConfigFeature = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)TechBlocks.maloberry_bush.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i.func_176223_P().func_177230_c())).func_227317_b_().func_227322_d_();
        raspBerryBushConfigFeature = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)TechBlocks.raspberry_bush.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i.func_176223_P().func_177230_c())).func_227317_b_().func_227322_d_();
        reedConfigFeature = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)TechBlocks.old_reed.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196660_k.func_176223_P().func_177230_c(), (Object)Blocks.field_150346_d.func_176223_P().func_177230_c(), (Object)Blocks.field_196658_i.func_176223_P().func_177230_c())).func_227317_b_().func_227322_d_();
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (ConfigHandler.bushes_terrain_gen) {
                TechFeatures.registerBushesToBiomes(biome);
            }
            TechFeatures.registerOres(biome);
            if (ConfigHandler.should_gen_quick_sand) {
                TechFeatures.addQuickSand(biome);
            }
            if (!reedWhitelist.contains(biome.func_201856_r())) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)reedConfigFeature).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        }
    }

    public static void registerBushesToBiomes(Biome biome) {
        for (Biome.Category selected : berryWhitelist) {
            if (!biome.func_201856_r().equals((Object)selected)) continue;
            TechFeatures.addBerryBushToBiome(biome);
        }
    }

    public static void registerOres(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.NETHER) {
            if (ConfigHandler.wub_ore_gen.booleanValue()) {
                TechFeatures.addNetherOre(biome, ((Block)TechBlocks.nether_wub_ore.get()).func_176223_P(), new CountRangeConfig(ConfigHandler.nether_wub_block_frequency, ConfigHandler.nether_wub_block_min, 0, ConfigHandler.nether_wub_block_max), ConfigHandler.nether_wub_block_count);
            }
            if (ConfigHandler.charcoal_ore_gen.booleanValue()) {
                TechFeatures.addNetherOre(biome, ((Block)TechBlocks.charcoal_block.get()).func_176223_P(), new CountRangeConfig(ConfigHandler.charcoal_frequency, ConfigHandler.charcoal_min, 0, ConfigHandler.charcoal_max), ConfigHandler.charcoal_size);
            }
            if (ConfigHandler.lava_block_gen.booleanValue()) {
                TechFeatures.addNetherOre(biome, ((Block)TechBlocks.nether_lava_block.get()).func_176223_P(), new CountRangeConfig(ConfigHandler.nether_lava_block_frequency, ConfigHandler.nether_lava_block_min, 0, ConfigHandler.nether_lava_block_max), ConfigHandler.lava_block_size);
            }
        } else {
            if (ConfigHandler.wub_ore_gen.booleanValue() && ConfigHandler.overworld_wub) {
                TechFeatures.addNatureOre(biome, ((Block)TechBlocks.wub_ore.get()).func_176223_P(), new CountRangeConfig(ConfigHandler.wub_block_frequency, ConfigHandler.wub_block_min, 0, ConfigHandler.wub_block_max), ConfigHandler.wub_block_count);
            }
            if (ConfigHandler.lava_block_gen.booleanValue()) {
                TechFeatures.addNatureOre(biome, ((Block)TechBlocks.lava_block.get()).func_176223_P(), new CountRangeConfig(ConfigHandler.lava_block_frequency, ConfigHandler.lava_block_min, 0, ConfigHandler.lava_block_max), ConfigHandler.lava_block_size);
            }
            if (ConfigHandler.ender_ore_gen.booleanValue()) {
                TechFeatures.addNatureOre(biome, ((Block)TechBlocks.ender_ore.get()).func_176223_P(), new CountRangeConfig(ConfigHandler.ender_ore_frequency, ConfigHandler.ender_ore_min, 0, ConfigHandler.ender_ore_max), ConfigHandler.ender_ore_size);
            }
            if (ConfigHandler.water_block_gen.booleanValue()) {
                TechFeatures.addNatureOre(biome, ((Block)TechBlocks.water_block.get()).func_176223_P(), new CountRangeConfig(ConfigHandler.water_block_frequency, ConfigHandler.water_block_min, 0, ConfigHandler.water_block_max), ConfigHandler.water_block_size);
            }
        }
    }

    private static void addBerryBushToBiome(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)blackBerryBushConfigFeature).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)blueBerryBushConfigFeature).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)maloBerryBushConfigFeature).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)raspBerryBushConfigFeature).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    private static void addNatureOre(Biome biomeIn, BlockState Ore, CountRangeConfig range, int orecount) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Ore, orecount)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)range)));
    }

    private static void addNetherOre(Biome biomeIn, BlockState Ore, CountRangeConfig range, int orecount) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, Ore, orecount)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)range)));
    }

    private static void addQuickSand(Biome biomeIn) {
        BlockStateFeatureConfig quickStandConfigFeature = new BlockStateFeatureConfig(((Block)TechBlocks.quick_sand.get()).func_176223_P());
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)QuickSandFeature.get()).func_225566_b_((IFeatureConfig)quickStandConfigFeature).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(60))));
    }

    static {
        berryWhitelist = Lists.newArrayList((Object[])new Biome.Category[]{Biome.Category.JUNGLE, Biome.Category.SWAMP, Biome.Category.PLAINS, Biome.Category.TAIGA, Biome.Category.EXTREME_HILLS});
        reedWhitelist = Lists.newArrayList((Object[])new Biome.Category[]{Biome.Category.PLAINS, Biome.Category.SWAMP});
    }
}

