/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.handlers.recipehandler;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeTagOutput
extends ShapedRecipe {
    private static final int MAX_HEIGHT = 3;
    private static final int MAX_WIDTH = 3;
    protected final ResourceLocation resultName;

    public RecipeTagOutput(ResourceLocation idIn, String groupIn, ResourceLocation result, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, ItemStack.field_190927_a);
        this.resultName = result;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return null;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        Collection list = ItemTags.func_199903_a().func_199915_b(this.resultName).func_199885_a();
        return new ItemStack((IItemProvider)list.stream().findFirst().orElse(Items.field_190931_a));
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull CraftingInventory var1) {
        Collection list = ItemTags.func_199903_a().func_199915_b(this.resultName).func_199885_a();
        return new ItemStack((IItemProvider)list.stream().findFirst().orElse(Items.field_190931_a));
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, RecipeTagOutput.firstNonSpace(s));
            int j1 = RecipeTagOutput.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static Map<String, Ingredient> deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeTagOutput> {
        public RecipeTagOutput read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map keyMap = RecipeTagOutput.deserializeKey(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] astring = RecipeTagOutput.shrink(RecipeTagOutput.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList ingredientsList = RecipeTagOutput.deserializeIngredients(astring, keyMap, i, j);
            String tagname = JSONUtils.func_151219_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (String)"tag", (String)"minecraft:air");
            return new RecipeTagOutput(recipeId, group, new ResourceLocation(tagname), i, j, (NonNullList<Ingredient>)ingredientsList);
        }

        public RecipeTagOutput read(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            int j = buffer.func_150792_a();
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList ingredientsList = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < ingredientsList.size(); ++k) {
                ingredientsList.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ResourceLocation result = new ResourceLocation(buffer.func_218666_n());
            return new RecipeTagOutput(recipeId, group, result, i, j, (NonNullList<Ingredient>)ingredientsList);
        }

        public void write(PacketBuffer buffer, RecipeTagOutput recipe) {
            buffer.func_150787_b(recipe.func_192403_f());
            buffer.func_150787_b(recipe.func_192404_g());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_180714_a(recipe.resultName.toString());
        }
    }
}

