/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.handlers.recipehandler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeFurnaceNBT
extends FurnaceRecipe {
    CompoundNBT resultNBT;

    public RecipeFurnaceNBT(ResourceLocation idIn, String groupIn, Ingredient ingredientIn, ItemStack resultIn, float experienceIn, int cookTimeIn) {
        super(idIn, groupIn, ingredientIn, resultIn, experienceIn, cookTimeIn);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeFurnaceNBT> {
        public final int cookTime = 200;

        public RecipeFurnaceNBT read(ResourceLocation recipeId, JsonObject json) {
            ItemStack itemstack;
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
            if (!json.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (json.get("result").isJsonObject()) {
                itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            } else {
                String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_218349_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            }
            if (json.has("resultNBT") && json.get("resultNBT").isJsonObject()) {
                CompoundNBT tag = new CompoundNBT();
                try {
                    tag = JsonToNBT.func_180713_a((String)json.get("resultNBT").getAsJsonObject().toString());
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
                if (!tag.isEmpty()) {
                    itemstack.func_77982_d(tag);
                }
            }
            float f = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
            int i = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)200);
            return new RecipeFurnaceNBT(recipeId, s, ingredient, itemstack, f, i);
        }

        public RecipeFurnaceNBT read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            float f = buffer.readFloat();
            int i = buffer.func_150792_a();
            return new RecipeFurnaceNBT(recipeId, s, ingredient, itemstack, f, i);
        }

        public void write(PacketBuffer buffer, RecipeFurnaceNBT recipe) {
            buffer.func_180714_a(recipe.field_222141_c);
            recipe.field_222142_d.func_199564_a(buffer);
            buffer.func_150788_a(recipe.field_222143_e);
            buffer.writeFloat(recipe.field_222144_f);
            buffer.func_150787_b(recipe.field_222145_g);
        }
    }
}

