/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.events;

import com.kashdeya.tinyprogressions.handlers.ArmorHandler;
import com.kashdeya.tinyprogressions.handlers.ConfigHandler;
import com.kashdeya.tinyprogressions.inits.TechFoods;
import com.kashdeya.tinyprogressions.inits.TechItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventDrops {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.HarvestDropsEvent event) {
        ItemEntity item;
        Block target = event.getState().func_177230_c();
        int trigger = event.getWorld().func_201674_k().nextInt(1000);
        if (target instanceof LeavesBlock) {
            if (trigger < ConfigHandler.peachDropsChance && ConfigHandler.extra_drops) {
                item = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack((IItemProvider)TechFoods.plump_peach.get(), ConfigHandler.peachDropsAmount));
                event.getWorld().func_217376_c((Entity)item);
            }
            if (trigger < ConfigHandler.pearDropsChance && ConfigHandler.extra_drops) {
                item = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack((IItemProvider)TechFoods.plump_pear.get(), ConfigHandler.pearDropsAmount));
                event.getWorld().func_217376_c((Entity)item);
            }
            if (trigger < ConfigHandler.appleDropsChance && ConfigHandler.extra_drops_vanilla) {
                item = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack((IItemProvider)Items.field_151034_e, ConfigHandler.appleDropsAmount));
                event.getWorld().func_217376_c((Entity)item);
            }
            if (trigger < ConfigHandler.stickDropsChance && ConfigHandler.extra_drops_vanilla) {
                item = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack((IItemProvider)Items.field_151055_y, ConfigHandler.stickDropsAmount));
                event.getWorld().func_217376_c((Entity)item);
            }
        }
        if (target == Blocks.field_150346_d || target == Blocks.field_150349_c || Tags.Blocks.DIRT.func_200570_b().contains(target) || target instanceof GrassBlock) {
            if (trigger < ConfigHandler.BoneDropsChance && ConfigHandler.BoneDrops) {
                item = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack((IItemProvider)Items.field_151103_aS, ConfigHandler.BoneAmount));
                event.getWorld().func_217376_c((Entity)item);
            }
            if (trigger < ConfigHandler.SkullDropsChance && ConfigHandler.SkullDrops) {
                item = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack((IItemProvider)Items.field_196182_dv, ConfigHandler.SkullAmount));
                event.getWorld().func_217376_c((Entity)item);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof EnderDragonEntity && ArmorHandler.dragon_armor) {
            EventDrops.registerMobDrop(event, event.getEntity(), true, new ItemStack((IItemProvider)TechItems.dragon_scale.get(), new Random().nextInt(16)));
        } else if (event.getEntity() instanceof WitherEntity && ConfigHandler.wither_rib) {
            EventDrops.registerMobDrop(event, event.getEntity(), true, new ItemStack((IItemProvider)TechItems.wither_rib.get(), new Random().nextInt(6)));
        }
    }

    private static void registerMobDrop(LivingDropsEvent event, Entity entity, boolean enableDrop, ItemStack drop) {
        if (enableDrop) {
            event.getEntityLiving().func_70099_a(drop, 0.0f);
        }
    }
}

