/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.config;

import com.kashdeya.tinyprogressions.handlers.ArmorHandler;
import com.kashdeya.tinyprogressions.handlers.ConfigHandler;
import com.kashdeya.tinyprogressions.handlers.FuelHandler;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class TinyConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final ForgeConfigSpec clientSpec;
    public static final ConfigCommon COMMON;
    public static final ConfigClient CLIENT;

    private static ForgeConfigSpec.IntValue lazyInt(ForgeConfigSpec.Builder builder, String var, int def, int min, int max, String com) {
        builder.comment(com);
        builder.translation("tp.config." + var.replaceAll(" ", "_"));
        return builder.defineInRange(var, def, min, max);
    }

    private static ForgeConfigSpec.DoubleValue lazyDouble(ForgeConfigSpec.Builder builder, String var, double def, double min, double max, String com) {
        builder.comment(com);
        builder.translation("tp.config." + var.replaceAll(" ", "_"));
        return builder.defineInRange(var, def, min, max);
    }

    private static ForgeConfigSpec.BooleanValue lazyBool(ForgeConfigSpec.Builder builder, String var, boolean def, String com) {
        builder.comment(com);
        builder.translation("tp.config." + var.replaceAll(" ", "_"));
        return builder.define(var, def);
    }

    private static ForgeConfigSpec.ConfigValue<String> lazyString(ForgeConfigSpec.Builder builder, String var, String def, String com) {
        builder.comment(com);
        builder.translation("tp.config." + var.replaceAll(" ", "_"));
        return builder.define(var, (Object)def);
    }

    private static ForgeConfigSpec.ConfigValue<List<? extends String>> lazyList(ForgeConfigSpec.Builder builder, String var, List<String> def, String com) {
        builder.comment(com);
        builder.translation("tp.config." + var.replaceAll(" ", "_"));
        return builder.defineList(var, def, o -> o instanceof String);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        if ("tp".equalsIgnoreCase(event.getConfig().getModId())) {
            if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
                TinyConfig.CLIENT.apply();
            } else if (event.getConfig().getType() == ModConfig.Type.COMMON) {
                TinyConfig.COMMON.apply();
                TinyConfig.loadJsonFiles();
            }
        }
    }

    @SubscribeEvent
    public static void onFileChanged(ModConfig.ModConfigEvent event) {
        if ("tp".equalsIgnoreCase(event.getConfig().getModId())) {
            if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
                TinyConfig.CLIENT.apply();
            } else if (event.getConfig().getType() == ModConfig.Type.COMMON) {
                TinyConfig.COMMON.apply();
                TinyConfig.loadJsonFiles();
            }
        }
    }

    private static void loadJsonFiles() {
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(x$0 -> new ConfigClient((ForgeConfigSpec.Builder)x$0));
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (ConfigClient)clientSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(x$0 -> new ConfigCommon((ForgeConfigSpec.Builder)x$0));
        commonSpec = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (ConfigCommon)commonSpecPair.getLeft();
    }

    public static class ConfigClient {
        private ConfigClient(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            builder.pop();
        }

        private void apply() {
        }
    }

    public static class ConfigCommon {
        private final ForgeConfigSpec.IntValue BlockGrowthTicks;
        private final ForgeConfigSpec.IntValue GrowthParticalTicks;
        private final ForgeConfigSpec.IntValue BlockGrowthUpgradeTicks;
        private final ForgeConfigSpec.IntValue GrowthUpgradeParticalTicks;
        private final ForgeConfigSpec.IntValue BlockGrowthUpgradeTwoTicks;
        private final ForgeConfigSpec.IntValue GrowthUpgradeTwoParticalTicks;
        private final ForgeConfigSpec.BooleanValue ParticalTicks;
        private final ForgeConfigSpec.IntValue WateringCanChance;
        private final ForgeConfigSpec.IntValue WateringCanUpgradeChance;
        private final ForgeConfigSpec.IntValue CharcoalBlockBurn;
        private final ForgeConfigSpec.IntValue FlintKnifeDamage;
        private final ForgeConfigSpec.IntValue QuartzKnifeDamage;
        private final ForgeConfigSpec.DoubleValue vasholine_heal_amount;
        private final ForgeConfigSpec.DoubleValue vasholine_mobs_amount;
        private final ForgeConfigSpec.DoubleValue mob_heal_amount;
        private final ForgeConfigSpec.BooleanValue vasholine_mobs;
        private final ForgeConfigSpec.BooleanValue wub_heal_mobs;
        private final ForgeConfigSpec.BooleanValue wub_weakness;
        private final ForgeConfigSpec.BooleanValue wub_blindness;
        private final ForgeConfigSpec.BooleanValue wub_fatigue;
        private final ForgeConfigSpec.IntValue smallBandageHealStack;
        private final ForgeConfigSpec.IntValue smallBandageRegen;
        private final ForgeConfigSpec.IntValue largeBandageStack;
        private final ForgeConfigSpec.IntValue largeBandageDuration;
        private final ForgeConfigSpec.IntValue largeBandageBoostTime;
        private final ForgeConfigSpec.IntValue smallMedHealStack;
        private final ForgeConfigSpec.IntValue smallMedDuration;
        private final ForgeConfigSpec.IntValue smallMedBoostTime;
        private final ForgeConfigSpec.IntValue LargeMedHealStack;
        private final ForgeConfigSpec.IntValue LargeMedDuration;
        private final ForgeConfigSpec.IntValue largeMedBoostTime;
        private final ForgeConfigSpec.IntValue kappa_level;
        private final ForgeConfigSpec.IntValue kappa_damage;
        private final ForgeConfigSpec.IntValue bams_pizza_amount;
        private final ForgeConfigSpec.DoubleValue bams_pizza_sat;
        private final ForgeConfigSpec.BooleanValue sea_axe;
        private final ForgeConfigSpec.BooleanValue sea_pickaxe;
        private final ForgeConfigSpec.IntValue lava_block_frequency;
        private final ForgeConfigSpec.IntValue lava_block_min;
        private final ForgeConfigSpec.IntValue lava_block_max;
        private final ForgeConfigSpec.IntValue lava_block_size;
        private final ForgeConfigSpec.IntValue nether_lava_block_frequency;
        private final ForgeConfigSpec.IntValue nether_lava_block_min;
        private final ForgeConfigSpec.IntValue nether_lava_block_max;
        private final ForgeConfigSpec.IntValue nether_lava_block_size;
        private final ForgeConfigSpec.IntValue water_block_frequency;
        private final ForgeConfigSpec.IntValue water_block_min;
        private final ForgeConfigSpec.IntValue water_block_max;
        private final ForgeConfigSpec.IntValue water_block_size;
        private final ForgeConfigSpec.BooleanValue ender_ore;
        private final ForgeConfigSpec.BooleanValue ender_mite;
        private final ForgeConfigSpec.IntValue endermite_spawn;
        private final ForgeConfigSpec.IntValue ender_ore_frequency;
        private final ForgeConfigSpec.IntValue ender_ore_min;
        private final ForgeConfigSpec.IntValue ender_ore_max;
        private final ForgeConfigSpec.IntValue ender_ore_size;
        private final ForgeConfigSpec.IntValue charcoal_size;
        private final ForgeConfigSpec.IntValue charcoal_max;
        private final ForgeConfigSpec.IntValue charcoal_min;
        private final ForgeConfigSpec.IntValue charcoal_frequency;
        private final ForgeConfigSpec.BooleanValue CharcoalWorldgen;
        private final ForgeConfigSpec.BooleanValue overworld_wub;
        private final ForgeConfigSpec.IntValue wub_block_count;
        private final ForgeConfigSpec.IntValue wub_block_frequency;
        private final ForgeConfigSpec.IntValue wub_block_min;
        private final ForgeConfigSpec.IntValue wub_block_max;
        private final ForgeConfigSpec.BooleanValue nether_wub;
        private final ForgeConfigSpec.IntValue nether_wub_block_count;
        private final ForgeConfigSpec.IntValue nether_wub_block_frequency;
        private final ForgeConfigSpec.IntValue nether_wub_block_min;
        private final ForgeConfigSpec.IntValue nether_wub_block_max;
        private final ForgeConfigSpec.IntValue tiny_charcoal_burntime;
        private final ForgeConfigSpec.IntValue tiny_coal_burntime;
        private final ForgeConfigSpec.IntValue repair_tablet_cooldown;
        private final ForgeConfigSpec.BooleanValue lava_armor_resistance;
        private final ForgeConfigSpec.BooleanValue lava_armor_fire;
        private final ForgeConfigSpec.IntValue lava_armor_resistance_lvl;
        private final ForgeConfigSpec.IntValue lava_armor_fire_lvl;
        private final ForgeConfigSpec.BooleanValue dragon_fly;
        private final ForgeConfigSpec.BooleanValue dragon_resistance;
        private final ForgeConfigSpec.BooleanValue dragon_fire;
        private final ForgeConfigSpec.BooleanValue dragon_strength;
        private final ForgeConfigSpec.IntValue dragon_fire_lvl;
        private final ForgeConfigSpec.IntValue dragon_resistance_lvl;
        private final ForgeConfigSpec.IntValue dragon_strength_lvl;
        private final ForgeConfigSpec.BooleanValue wither_resistance;
        private final ForgeConfigSpec.BooleanValue wither_fire;
        private final ForgeConfigSpec.BooleanValue wither_strength;
        private final ForgeConfigSpec.IntValue wither_resistance_lvl;
        private final ForgeConfigSpec.IntValue wither_fire_lvl;
        private final ForgeConfigSpec.IntValue wither_strength_lvl;
        private final ForgeConfigSpec.BooleanValue lapis_armor_water;
        private final ForgeConfigSpec.IntValue lapis_armor_water_lvl;
        private final ForgeConfigSpec.BooleanValue obsidian_armor_resistance;
        private final ForgeConfigSpec.IntValue obsidian_armor_resistance_lvl;
        private final ForgeConfigSpec.BooleanValue quartz_armor_strength;
        private final ForgeConfigSpec.IntValue quartz_armor_strength_lvl;
        private final ForgeConfigSpec.BooleanValue redstone_armor_speed;
        private final ForgeConfigSpec.IntValue redstone_armor_speed_lvl;
        private final ForgeConfigSpec.DoubleValue spear_reach;
        private final ForgeConfigSpec.IntValue AppleAmount;
        private final ForgeConfigSpec.IntValue CarrotAmount;
        private final ForgeConfigSpec.IntValue PotatoAmount;
        private final ForgeConfigSpec.IntValue BeetAmount;
        private final ForgeConfigSpec.IntValue CactusAmount;
        private final ForgeConfigSpec.IntValue SlimeAmount;
        private final ForgeConfigSpec.IntValue WheatAmount;
        private final ForgeConfigSpec.IntValue MelonAmount;
        private final ForgeConfigSpec.IntValue PumpkinAmount;
        private final ForgeConfigSpec.DoubleValue AppleSaturation;
        private final ForgeConfigSpec.DoubleValue CarrotSaturation;
        private final ForgeConfigSpec.DoubleValue PotatoSaturation;
        private final ForgeConfigSpec.DoubleValue BeetSaturation;
        private final ForgeConfigSpec.DoubleValue CactusSaturation;
        private final ForgeConfigSpec.DoubleValue SlimeSaturation;
        private final ForgeConfigSpec.DoubleValue WheatSaturation;
        private final ForgeConfigSpec.DoubleValue MelonSaturation;
        private final ForgeConfigSpec.DoubleValue PumpkinSaturation;
        private final ForgeConfigSpec.BooleanValue ExtraPlantGen;
        private final ForgeConfigSpec.IntValue berryPlantRarity;
        private final ForgeConfigSpec.IntValue BlueberryAmount;
        private final ForgeConfigSpec.IntValue BlackberryAmount;
        private final ForgeConfigSpec.IntValue MaloberryAmount;
        private final ForgeConfigSpec.IntValue RaspberryAmount;
        private final ForgeConfigSpec.IntValue ToastedAmount;
        private final ForgeConfigSpec.IntValue eat_timer;
        private final ForgeConfigSpec.DoubleValue BlueberrySaturation;
        private final ForgeConfigSpec.DoubleValue BlackberrySaturation;
        private final ForgeConfigSpec.DoubleValue MaloberrySaturation;
        private final ForgeConfigSpec.DoubleValue RaspberrySaturation;
        private final ForgeConfigSpec.DoubleValue ToastedSaturation;
        private ForgeConfigSpec.BooleanValue quick_sand_generation;
        private ForgeConfigSpec.BooleanValue berry_bushes_generation;
        private ForgeConfigSpec.BooleanValue wub_ore_generation;
        private ForgeConfigSpec.BooleanValue charcoal_ore_generation;
        private ForgeConfigSpec.BooleanValue ender_ore_generation;
        private ForgeConfigSpec.BooleanValue lava_block_generation;
        private ForgeConfigSpec.BooleanValue water_block_generation;

        private ConfigCommon(ForgeConfigSpec.Builder builder) {
            builder.push("Main");
            builder.push("Growth Crystal").comment("These like to grow things!");
            builder.push("Tier 1");
            this.BlockGrowthTicks = TinyConfig.lazyInt(builder, "Growth Crystal Tier 1 Speed", 60, 1, 100, "Number of Ticks between Growth Ticks.\n[1 = 40 Ticks or 2 Seconds]\n[Default*40=1200 Ticks]");
            this.GrowthParticalTicks = TinyConfig.lazyInt(builder, "Growth Crystal Tier 1 Particles", 1000, 50, 1000, "Lower Number gives more Particles");
            builder.pop();
            builder.push("Tier 2");
            this.BlockGrowthUpgradeTicks = TinyConfig.lazyInt(builder, "Growth Crystal Tier 2 Speed", 30, 1, 100, "Number of Ticks between Growth Ticks.\n[1 = 20 Ticks or 1 Second]\n[Default*20=800 Ticks]");
            this.GrowthUpgradeParticalTicks = TinyConfig.lazyInt(builder, "Growth Crystal Tier 2 Particles", 1000, 50, 1000, "Lower Number gives more Particles");
            builder.pop();
            builder.push("Tier 3");
            this.BlockGrowthUpgradeTwoTicks = TinyConfig.lazyInt(builder, "Growth Crystal Tier 3 Speed", 30, 1, 100, "Number of Ticks between Growth Ticks.\n[1 = 10 Ticks or 1/2 a Second]\n[Default*10=400 Ticks]");
            this.GrowthUpgradeTwoParticalTicks = TinyConfig.lazyInt(builder, "Growth Crystal Tier 3 Particles", 1000, 50, 1000, "Lower Number gives more Particles");
            builder.pop();
            this.ParticalTicks = TinyConfig.lazyBool(builder, "Growth Crystal Particles", false, "Enable Growth Crystal Particles?");
            builder.pop();
            builder.comment("Remember to water those plants!").push("Watering Cans");
            this.WateringCanChance = TinyConfig.lazyInt(builder, "Watering Can Chance", 50, 1, 50, "Chance out of 50 that the Watering Can will tick the plant!");
            this.WateringCanUpgradeChance = TinyConfig.lazyInt(builder, "Watering Can Reinforced Chance", 100, 50, 100, "Chance out of 100 that the Watering Can will tick the plant!");
            builder.pop();
            builder.comment("It's the little things that count right?").push("Charcoal");
            this.CharcoalBlockBurn = TinyConfig.lazyInt(builder, "Charcoal Block Burn Time", 16000, 0, Integer.MAX_VALUE, "Sets the burn time for the Charcoal Block.");
            builder.pop();
            builder.pop();
            builder.push("Supporters");
            builder.push("Custom Packs").comment("Added for Custom Packs!\n[If you enable please make a recipe for them, Other wise they do nothing.]");
            this.FlintKnifeDamage = TinyConfig.lazyInt(builder, "Flint Knife Durability", 100, 0, Integer.MAX_VALUE, "Sets the amount of Durability.");
            this.QuartzKnifeDamage = TinyConfig.lazyInt(builder, "Quartz Knife Durability", 128, 0, Integer.MAX_VALUE, "Sets the amount of Durability.");
            builder.pop();
            builder.comment("WUB WUB WUB!").push("WUB Juice");
            this.vasholine_heal_amount = TinyConfig.lazyDouble(builder, "WUB Juice Heal Amount", 0.25, 0.0, 1.0, "Sets the amount of heal Wub Juice does per tick.");
            this.vasholine_mobs = TinyConfig.lazyBool(builder, "WUB Juice Hurts Mobs", true, "Enable mobs getting hurt?");
            this.vasholine_mobs_amount = TinyConfig.lazyDouble(builder, "WUB Juice Hurts Mobs Amount", 0.01, 0.0, 1.0, "Sets the amount mobs get hurt.");
            this.wub_heal_mobs = TinyConfig.lazyBool(builder, "WUB Juice Heals Mobs", false, "Enable mobs getting healed?");
            this.mob_heal_amount = TinyConfig.lazyDouble(builder, "WUB Juice Heals Mobs Amount", 0.01, 0.0, 1.0, "Sets the amount mobs get healed.");
            this.wub_weakness = TinyConfig.lazyBool(builder, "WUB Juice Side Effect Weakness", true, "Enable Weakness while being healed?");
            this.wub_blindness = TinyConfig.lazyBool(builder, "WUB Juice Side Effect Blindness", true, "Enable Blindness while being healed?");
            this.wub_fatigue = TinyConfig.lazyBool(builder, "WUB Juice Side Effect Mining Fatigue", true, "Enable Mining Fatigue while being healed?");
            builder.pop();
            builder.comment("Need a little healing?\n[Each teir requires the lower teir for crafting!]\n[Medical Items can now only be used if player is hurt!]").push("Medical Items");
            this.smallBandageHealStack = TinyConfig.lazyInt(builder, "Teir 1 Meical Item Stacksize", 8, 1, 64, "Sets the Stacksize of the Small Medical Bandage!");
            this.smallBandageRegen = TinyConfig.lazyInt(builder, "Teir 1 Meical Item Regen Time", 5, 1, 30, "Sets the length of regen of the Small Medical Bandage!\n[Does not stack]");
            this.largeBandageStack = TinyConfig.lazyInt(builder, "Teir 2 Meical Item Stacksize", 16, 1, 64, "Sets the Stacksize of the Large Medical Bandage!");
            this.largeBandageDuration = TinyConfig.lazyInt(builder, "Teir 2 Meical Item Use Duration", 4, 1, 64, "Sets how long it takes the player to apply the Large Medical Bandage!");
            this.largeBandageBoostTime = TinyConfig.lazyInt(builder, "Teir 2 Meical Item Boost Time", 15, 0, 120, "Sets how long the player has 2 extra hearts on the Large Medical Bandage!\n[Does not stack]");
            this.smallMedHealStack = TinyConfig.lazyInt(builder, "Teir 3 Meical Item Stacksize", 16, 1, 64, "Sets the Stacksize of the Small Medical Kit!");
            this.smallMedDuration = TinyConfig.lazyInt(builder, "Teir 3 Meical Item Use Duration", 8, 1, 64, "Sets how long it takes the player to apply the Small Medical Kit!");
            this.smallMedBoostTime = TinyConfig.lazyInt(builder, "Teir 3 Meical Item Boost Time", 30, 0, 240, "Sets how long the player has 4 extra hearts on the Small Medical Kit!\n[Does not stack]");
            this.LargeMedHealStack = TinyConfig.lazyInt(builder, "Teir 4 Meical Item Stacksize", 16, 1, 64, "Sets the Stacksize of the Large Medical Kit!");
            this.LargeMedDuration = TinyConfig.lazyInt(builder, "Teir 4 Meical Item Use Duration", 16, 1, 64, "Sets how long it takes the player to apply the Large Medical Kit!");
            this.largeMedBoostTime = TinyConfig.lazyInt(builder, "Teir 4 Meical Item Boost Time", 60, 0, 300, "Sets how long the player has 6 extra hearts on the Large Medical Kit!\n[Does not stack]");
            builder.pop();
            builder.comment("Fun Stuff\n[Not PicKappa stop asking!]").push("Kappa Pick");
            this.kappa_level = TinyConfig.lazyInt(builder, "Kappa Pick Mining Level", 1, 0, 3, "Mining Level.");
            this.kappa_damage = TinyConfig.lazyInt(builder, "Kappa Pick Mining Level Durability", 31513, 100, Integer.MAX_VALUE, "Durability Level.");
            builder.pop();
            builder.comment("Because Pineapple goes on Pizza! Kappa").push("Pizza");
            this.bams_pizza_amount = TinyConfig.lazyInt(builder, "Bams Pizza Heal Amount", 10, 1, 20, "Sets the Heal Amount.");
            this.bams_pizza_sat = TinyConfig.lazyDouble(builder, "Bams Pizza Saturation Amount", 1.0, 0.0, 1.0, "Sets the Saturation Amount.");
            builder.pop();
            builder.comment("A Funny Thing").push("Sea Axe");
            this.sea_axe = TinyConfig.lazyBool(builder, "Sea Axe - Axe", true, "Enable Sea Axe as a Axe?\n[Axe has 11 attack damage!]\n[Only ENABLE if Sea Axe - Pickaxe is DISABLED!]\n[Sea Axe must be ENABLED for this config to work!]");
            this.sea_pickaxe = TinyConfig.lazyBool(builder, "Sea Axe - Pickaxe", false, "Enable Sea Axe as a Pickaxe?\n[Pickaxe has 10 attack damage!]\n[Only ENABLE if Sea Axe - Axe is DISABLED!]\n[Sea Axe must be ENABLED for this config to work!]");
            builder.pop();
            builder.pop();
            builder.push("Ores");
            builder.comment("Lavastone!").push("Lava Source Block Stones");
            this.lava_block_frequency = TinyConfig.lazyInt(builder, "Lavastone Gen Frequency", 5, 1, 100, "Sets the Chance of Lavastone generating.");
            this.lava_block_min = TinyConfig.lazyInt(builder, "Lavastone Gen Min", 12, 1, 255, "Sets the min Y level.");
            this.lava_block_max = TinyConfig.lazyInt(builder, "Lavastone Gen Max", 32, 1, 255, "Sets the max Y level.");
            this.lava_block_size = TinyConfig.lazyInt(builder, "Lavastone Gen Size", 4, 1, 100, "Sets the Lavastone Vein Size.");
            builder.pop();
            builder.comment("Nether Lavastone!").push("Nether Lava Source Block Stones");
            this.nether_lava_block_frequency = TinyConfig.lazyInt(builder, "Nether Lavastone Gen Frequency", 5, 1, 100, "Sets the Chance of Nether Lavastone generating.");
            this.nether_lava_block_min = TinyConfig.lazyInt(builder, "Nether Lavastone Gen Min", 12, 1, 255, "Sets the min Y level.");
            this.nether_lava_block_max = TinyConfig.lazyInt(builder, "Nether Lavastone Gen Max", 32, 1, 255, "Sets the max Y level.");
            this.nether_lava_block_size = TinyConfig.lazyInt(builder, "Nether Lavastone Gen Size", 4, 1, 100, "Sets the Nether Lavastone Vein Size.");
            builder.pop();
            builder.comment("Waterstone!").push("Water Source Block Stones");
            this.water_block_frequency = TinyConfig.lazyInt(builder, "Waterstone Gen Frequency", 5, 1, 100, "Sets the Chance of Waterstone generating.");
            this.water_block_min = TinyConfig.lazyInt(builder, "Waterstone Gen Min", 32, 1, 255, "Sets the min Y level.");
            this.water_block_max = TinyConfig.lazyInt(builder, "Waterstone Gen Max", 48, 1, 255, "Sets the max Y level.");
            this.water_block_size = TinyConfig.lazyInt(builder, "Waterstone Gen Size", 4, 1, 100, "Sets the Waterstone Vein Size.");
            builder.pop();
            builder.comment("Might as well add this!").push("Ender Ore");
            this.ender_ore = TinyConfig.lazyBool(builder, "Ender Ore", true, "World Generate Ender Ore?");
            this.ender_mite = TinyConfig.lazyBool(builder, "Endermite", true, "Enable Endermite spawn?");
            this.endermite_spawn = TinyConfig.lazyInt(builder, "Endermite Spawn", 25, 0, 100, "Sets the Chance of Endermites to spawn when Ore is mined.");
            this.ender_ore_frequency = TinyConfig.lazyInt(builder, "Ender Ore Frequency", 5, 1, 100, "Sets the Chance of Ender ore generating.");
            this.ender_ore_min = TinyConfig.lazyInt(builder, "Ender Ore Min", 1, 1, 255, "Sets the min Y level.");
            this.ender_ore_max = TinyConfig.lazyInt(builder, "Ender Ore Max", 32, 1, 255, "Sets the max Y level.");
            this.ender_ore_size = TinyConfig.lazyInt(builder, "Ender Ore Size", 4, 1, 100, "Sets the Ender Ore Vein Size.");
            builder.pop();
            builder.comment("It's the little things that count right?!").push("Charcoal");
            this.CharcoalWorldgen = TinyConfig.lazyBool(builder, "Charcoal Block Nether Worldgen", true, "Enable the Charcoal Block to spawn in the nether?");
            this.charcoal_frequency = TinyConfig.lazyInt(builder, "Charcoal Block Nether Worldgen Frequency", 10, 1, 100, "Sets the Chance of Charcoal Block.");
            this.charcoal_min = TinyConfig.lazyInt(builder, "Charcoal Block Nether Worldgen Min", 1, 1, 255, "Sets the min Y level.");
            this.charcoal_max = TinyConfig.lazyInt(builder, "Charcoal Block Nether Worldgen Max", 128, 1, 255, "Sets the max Y level.");
            this.charcoal_size = TinyConfig.lazyInt(builder, "Charcoal Block Nether Worldgen Size", 10, 1, 100, "Sets the Charcoal Vein Size.");
            builder.pop();
            builder.push("WUB Juice Overworld Ore");
            this.overworld_wub = TinyConfig.lazyBool(builder, "Overworld Wub Ore", true, "Enable Overworld Wub Ore?");
            this.wub_block_count = TinyConfig.lazyInt(builder, "Overworld Wub Ore Gen Size", 5, 1, 100, "Sets the Overworld Wub Ore Vein Size.");
            this.wub_block_frequency = TinyConfig.lazyInt(builder, "Overworld Wub Ore Gen Chance", 50, 1, 100, "Sets the Chance of Overworld Wub Ore generating.");
            this.wub_block_min = TinyConfig.lazyInt(builder, "Overworld Wub Ore Gen Min", 1, 1, 255, "Sets the Overworld min Y level.");
            this.wub_block_max = TinyConfig.lazyInt(builder, "Overworld Wub Ore Gen Max", 255, 1, 255, "Sets the Overworld max Y level.");
            builder.pop();
            builder.push("WUB Juice Nether Ore");
            this.nether_wub = TinyConfig.lazyBool(builder, "Nether Wub Ore", true, "WorldGen Nether Wub Ore?");
            this.nether_wub_block_count = TinyConfig.lazyInt(builder, "Nether Wub Ore Gen Size", 5, 1, 100, "Sets the Nether Wub Ore Vein Size.");
            this.nether_wub_block_frequency = TinyConfig.lazyInt(builder, "Nether Wub Ore Gen Chance", 50, 1, 100, "Sets the Chance of Nether Wub Ore generating.");
            this.nether_wub_block_min = TinyConfig.lazyInt(builder, "Nether Wub Ore Gen Min", 1, 1, 120, "Sets the Nether min Y level.");
            this.nether_wub_block_max = TinyConfig.lazyInt(builder, "Nether Wub Ore Gen Max", 120, 1, 120, "Sets the Nether max Y level.");
            builder.pop();
            builder.pop();
            builder.push("Extras");
            builder.push("Tiny Coal & Charcoal");
            this.tiny_charcoal_burntime = TinyConfig.lazyInt(builder, "Tiny Charcoal Burn Time", 200, 0, Integer.MAX_VALUE, "Sets the burn time for Tiny Charcoal.");
            this.tiny_coal_burntime = TinyConfig.lazyInt(builder, "Tiny Coal Burn Time", 200, 0, Integer.MAX_VALUE, "Sets the burn time for Tiny Coal.");
            builder.pop();
            builder.comment("Need some extra durability, eh?\n[Repairs Items in Players Inventory only.]").push("Repair Tablet");
            this.repair_tablet_cooldown = TinyConfig.lazyInt(builder, "Repair Tablet Cooldown", 20, 1, Integer.MAX_VALUE, "Cooldown (in ticks) between repair processes.");
            builder.pop();
            builder.pop();
            builder.push("Armor");
            builder.comment("What Armor?").push("Lava Armor");
            this.lava_armor_resistance = TinyConfig.lazyBool(builder, "Lava Armor Resistance", true, "Enable Lava Armor Resistance?");
            this.lava_armor_resistance_lvl = TinyConfig.lazyInt(builder, "Lava Armor Resistance Level", 0, 0, 10, "Resistance Level.");
            this.lava_armor_fire = TinyConfig.lazyBool(builder, "Lava Armor Fire Resistance", true, "Enable Lava Armor Fire Resistance?");
            this.lava_armor_fire_lvl = TinyConfig.lazyInt(builder, "Lava Armor Fire Resistance Level", 0, 0, 10, "Fire Resistance Level.");
            builder.pop();
            builder.comment("End Game Armor").push("Dragon Armor");
            this.dragon_fly = TinyConfig.lazyBool(builder, "Dragon Armor Allow Flight", true, "Enable Dragon Armor Flight?");
            this.dragon_resistance = TinyConfig.lazyBool(builder, "Dragon Armor Resistance", true, "Enable Dragon Armor Resistance?");
            this.dragon_resistance_lvl = TinyConfig.lazyInt(builder, "Dragon Armor Resistance Level", 1, 0, 10, "Resistance Level.");
            this.dragon_fire = TinyConfig.lazyBool(builder, "Dragon Armor Fire Resistance", true, "Enable Dragon Armor Fire Resistance?");
            this.dragon_fire_lvl = TinyConfig.lazyInt(builder, "Dragon Armor Fire Resistance Level", 1, 0, 10, "Fire Resistance Level.");
            this.dragon_strength = TinyConfig.lazyBool(builder, "Dragon Armor Strength", true, "Enable Dragon Armor Strength?");
            this.dragon_strength_lvl = TinyConfig.lazyInt(builder, "Dragon Armor Strength Level", 1, 0, 10, "Strength Level.");
            builder.pop();
            builder.comment("Mid Game Armor").push("Wither Armor");
            this.wither_resistance = TinyConfig.lazyBool(builder, "Wither Armor Resistance", true, "Enable Wither Armor Resistance?");
            this.wither_resistance_lvl = TinyConfig.lazyInt(builder, "Wither Armor Resistance Level", 0, 0, 10, "Resistance Level.");
            this.wither_fire = TinyConfig.lazyBool(builder, "Wither Armor Fire Resistance", true, "Enable Wither Armor Fire Resistance?");
            this.wither_fire_lvl = TinyConfig.lazyInt(builder, "Wither Armor Fire Resistance Level", 0, 0, 10, "Fire Resistance Level.");
            this.wither_strength = TinyConfig.lazyBool(builder, "Wither Armor Strength", true, "Enable Wither Armor Strength?");
            this.wither_strength_lvl = TinyConfig.lazyInt(builder, "Wither Armor Strength Level", 0, 0, 10, "Strength Level.");
            builder.pop();
            builder.comment("Lets go under the water").push("Lapis Armor");
            this.lapis_armor_water = TinyConfig.lazyBool(builder, "Lapis Armor Water Breathing", true, "Enable Lapis Water Breathing?");
            this.lapis_armor_water_lvl = TinyConfig.lazyInt(builder, "Lapis Armor Water Breathing Level", 0, 0, 10, "Water Breathing Level.");
            builder.pop();
            builder.comment("What?").push("Obsidian Armor");
            this.obsidian_armor_resistance = TinyConfig.lazyBool(builder, "Obsidian Armor Resistance", true, "Enable Obsidian Resistance?");
            this.obsidian_armor_resistance_lvl = TinyConfig.lazyInt(builder, "Obsidian Armor Resistance Level", 0, 0, 10, "Resistance Level.");
            builder.pop();
            builder.comment("You went where?").push("Quartz Armor");
            this.quartz_armor_strength = TinyConfig.lazyBool(builder, "Quartz Armor Strength", true, "Enable Quartz Strength?");
            this.quartz_armor_strength_lvl = TinyConfig.lazyInt(builder, "Quartz Armor Strength Level", 0, 0, 10, "Strength Level.");
            builder.pop();
            builder.comment("How fast you want to go?").push("Redstone Armor");
            this.redstone_armor_speed = TinyConfig.lazyBool(builder, "Redstone Armor Speed", true, "Enable Redstone Speed?");
            this.redstone_armor_speed_lvl = TinyConfig.lazyInt(builder, "Redstone Armor Speed Level", 0, 0, 10, "Speed Level.");
            builder.pop();
            builder.pop();
            builder.push("Tools & Weapons");
            builder.push("Spears");
            this.spear_reach = TinyConfig.lazyDouble(builder, "A Spears Extended Reach", 7.0, 5.0, 10.0, "Sets the Reach of a Spear.\n[Vanilla is 5 blocks!]");
            builder.pop();
            builder.pop();
            builder.push("Terrain Generation");
            this.quick_sand_generation = TinyConfig.lazyBool(builder, "Quick Sand Gen", true, "Spawn quick sand traps in the overworld");
            this.berry_bushes_generation = TinyConfig.lazyBool(builder, "Berry Bush Gen", true, "Spawn berry bushes in the overworld");
            builder.pop();
            builder.push("Ore Generation");
            this.wub_ore_generation = TinyConfig.lazyBool(builder, "Wub Ore Gen", true, "Add Wub Ore to World Generation");
            this.charcoal_ore_generation = TinyConfig.lazyBool(builder, "Charcoal Ore Gen", true, "Add Charcoal Ore to World Generation");
            this.ender_ore_generation = TinyConfig.lazyBool(builder, "Ender Ore Gen", true, "Add Ender Ore to World Generation");
            this.lava_block_generation = TinyConfig.lazyBool(builder, "Lava Block Gen", true, "Add Lava Block to World Generation");
            this.water_block_generation = TinyConfig.lazyBool(builder, "Water Block Gen", true, "Add Water Block to World Generation");
            builder.pop();
            builder.push("Food & Drinks");
            builder.comment("Everyone loves juice Stats!").push("Juice Stats");
            this.AppleAmount = TinyConfig.lazyInt(builder, "Apple Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.AppleSaturation = TinyConfig.lazyDouble(builder, "Apple Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.CarrotAmount = TinyConfig.lazyInt(builder, "Carrot Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.CarrotSaturation = TinyConfig.lazyDouble(builder, "Carrot Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.PotatoAmount = TinyConfig.lazyInt(builder, "Potato Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.PotatoSaturation = TinyConfig.lazyDouble(builder, "Potato Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.BeetAmount = TinyConfig.lazyInt(builder, "Beet Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.BeetSaturation = TinyConfig.lazyDouble(builder, "Beet Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.CactusAmount = TinyConfig.lazyInt(builder, "Cactus Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.CactusSaturation = TinyConfig.lazyDouble(builder, "Cactus Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.SlimeAmount = TinyConfig.lazyInt(builder, "Slime Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.SlimeSaturation = TinyConfig.lazyDouble(builder, "Slime Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.WheatAmount = TinyConfig.lazyInt(builder, "Wheat Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.WheatSaturation = TinyConfig.lazyDouble(builder, "Wheat Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.MelonAmount = TinyConfig.lazyInt(builder, "Melon Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.MelonSaturation = TinyConfig.lazyDouble(builder, "Melon Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.PumpkinAmount = TinyConfig.lazyInt(builder, "Pumpkin Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.PumpkinSaturation = TinyConfig.lazyDouble(builder, "Pumpkin Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            builder.pop();
            builder.comment("Extra Berry Plants!\n[Disable Extra Plant Generation if you want to use Naturas Berries instead!]\n[The higher the value, the more Plants are generated.]").push("Modded Juice Generation");
            this.ExtraPlantGen = TinyConfig.lazyBool(builder, "Extra Plant Generation", true, "Enable Extra Plant Generation?");
            this.berryPlantRarity = TinyConfig.lazyInt(builder, "Extra Plant Generation Rarity", 5, 1, Integer.MAX_VALUE, "Sets the Rarity of Berry Plants.");
            builder.pop();
            builder.comment("Everyone loves juice Stats!").push("Juice Stats");
            this.BlueberryAmount = TinyConfig.lazyInt(builder, "Blueberry Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.BlueberrySaturation = TinyConfig.lazyDouble(builder, "Blueberry Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.BlackberryAmount = TinyConfig.lazyInt(builder, "Blackberry Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.BlackberrySaturation = TinyConfig.lazyDouble(builder, "Blackberry Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.MaloberryAmount = TinyConfig.lazyInt(builder, "Maloberry Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.MaloberrySaturation = TinyConfig.lazyDouble(builder, "Maloberry Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            this.RaspberryAmount = TinyConfig.lazyInt(builder, "Raspberry Juice Heal Amount", 4, 1, 20, "Sets the Heal Amount.");
            this.RaspberrySaturation = TinyConfig.lazyDouble(builder, "Raspberry Juice Saturation Amount", 0.3f, 0.0, 1.0, "Sets the Saturation Amount.");
            builder.pop();
            builder.comment("Want more food Stats?\n[WIP Section]").push("Extra Food Stats");
            this.ToastedAmount = TinyConfig.lazyInt(builder, "Toasted Bread Heal Amount", 6, 1, 20, "Sets the Heal Amount.");
            this.ToastedSaturation = TinyConfig.lazyDouble(builder, "Toasted Bread Saturation Amount", 0.7f, 0.0, 1.0, "Sets the Saturation Amount.");
            builder.pop();
            builder.comment("How long it takes to eat food.").push("Food Eat Duration");
            this.eat_timer = TinyConfig.lazyInt(builder, "Eat Duration", 32, 8, Integer.MAX_VALUE, "Sets how long it takes to eat TP food.");
            builder.pop();
            builder.pop();
        }

        private void apply() {
            ConfigHandler.BlockGrowthTicks = (Integer)this.BlockGrowthTicks.get();
            ConfigHandler.GrowthParticalTicks = (Integer)this.GrowthParticalTicks.get();
            ConfigHandler.BlockGrowthUpgradeTicks = (Integer)this.BlockGrowthUpgradeTicks.get();
            ConfigHandler.GrowthUpgradeParticalTicks = (Integer)this.GrowthUpgradeParticalTicks.get();
            ConfigHandler.BlockGrowthUpgradeTwoTicks = (Integer)this.BlockGrowthUpgradeTwoTicks.get();
            ConfigHandler.GrowthUpgradeTwoParticalTicks = (Integer)this.GrowthUpgradeTwoParticalTicks.get();
            ConfigHandler.ParticalTicks = (Boolean)this.ParticalTicks.get();
            ConfigHandler.WateringCanChance = (Integer)this.WateringCanChance.get();
            ConfigHandler.WateringCanUpgradeChance = (Integer)this.WateringCanUpgradeChance.get();
            FuelHandler.CharcoalBlockBurn = (Integer)this.CharcoalBlockBurn.get();
            ConfigHandler.FlintKnifeDamage = (Integer)this.FlintKnifeDamage.get();
            ConfigHandler.QuartzKnifeDamage = (Integer)this.QuartzKnifeDamage.get();
            ConfigHandler.vasholine_heal_amount = ((Double)this.vasholine_heal_amount.get()).floatValue();
            ConfigHandler.vasholine_mobs = (Boolean)this.vasholine_mobs.get();
            ConfigHandler.vasholine_mobs_amount = ((Double)this.vasholine_mobs_amount.get()).floatValue();
            ConfigHandler.wub_heal_mobs = (Boolean)this.wub_heal_mobs.get();
            ConfigHandler.mob_heal_amount = ((Double)this.mob_heal_amount.get()).floatValue();
            ConfigHandler.wub_weakness = (Boolean)this.wub_weakness.get();
            ConfigHandler.wub_blindness = (Boolean)this.wub_blindness.get();
            ConfigHandler.wub_fatigue = (Boolean)this.wub_fatigue.get();
            ConfigHandler.smallBandageHealStack = (Integer)this.smallBandageHealStack.get();
            ConfigHandler.smallBandageRegen = (Integer)this.smallBandageRegen.get();
            ConfigHandler.largeBandageStack = (Integer)this.largeBandageStack.get();
            ConfigHandler.largeBandageDuration = (Integer)this.largeBandageDuration.get();
            ConfigHandler.largeBandageBoostTime = (Integer)this.largeBandageBoostTime.get();
            ConfigHandler.smallMedHealStack = (Integer)this.smallMedHealStack.get();
            ConfigHandler.smallMedDuration = (Integer)this.smallMedDuration.get();
            ConfigHandler.smallMedBoostTime = (Integer)this.smallMedBoostTime.get();
            ConfigHandler.LargeMedHealStack = (Integer)this.LargeMedHealStack.get();
            ConfigHandler.LargeMedDuration = (Integer)this.LargeMedDuration.get();
            ConfigHandler.largeMedBoostTime = (Integer)this.largeMedBoostTime.get();
            ConfigHandler.kappa_level = (Integer)this.kappa_level.get();
            ConfigHandler.kappa_damage = (Integer)this.kappa_damage.get();
            ConfigHandler.bams_pizza_amount = (Integer)this.bams_pizza_amount.get();
            ConfigHandler.bams_pizza_sat = ((Double)this.bams_pizza_sat.get()).floatValue();
            ConfigHandler.sea_axe = (Boolean)this.sea_axe.get();
            ConfigHandler.sea_pickaxe = (Boolean)this.sea_pickaxe.get();
            ConfigHandler.lava_block_frequency = (Integer)this.lava_block_frequency.get();
            ConfigHandler.lava_block_min = (Integer)this.lava_block_min.get();
            ConfigHandler.lava_block_max = (Integer)this.lava_block_max.get();
            ConfigHandler.lava_block_size = (Integer)this.lava_block_size.get();
            ConfigHandler.nether_lava_block_frequency = (Integer)this.nether_lava_block_frequency.get();
            ConfigHandler.nether_lava_block_min = (Integer)this.nether_lava_block_min.get();
            ConfigHandler.nether_lava_block_max = (Integer)this.nether_lava_block_max.get();
            ConfigHandler.nether_lava_block_size = (Integer)this.nether_lava_block_size.get();
            ConfigHandler.water_block_frequency = (Integer)this.water_block_frequency.get();
            ConfigHandler.water_block_min = (Integer)this.water_block_min.get();
            ConfigHandler.water_block_max = (Integer)this.water_block_max.get();
            ConfigHandler.water_block_size = (Integer)this.water_block_size.get();
            ConfigHandler.ender_ore = (Boolean)this.ender_ore.get();
            ConfigHandler.ender_mite = (Boolean)this.ender_mite.get();
            ConfigHandler.endermite_spawn = (Integer)this.endermite_spawn.get();
            ConfigHandler.ender_ore_frequency = (Integer)this.ender_ore_frequency.get();
            ConfigHandler.ender_ore_min = (Integer)this.ender_ore_min.get();
            ConfigHandler.ender_ore_max = (Integer)this.ender_ore_max.get();
            ConfigHandler.ender_ore_size = (Integer)this.ender_ore_size.get();
            ConfigHandler.CharcoalWorldgen = (Boolean)this.CharcoalWorldgen.get();
            ConfigHandler.charcoal_frequency = (Integer)this.charcoal_frequency.get();
            ConfigHandler.charcoal_min = (Integer)this.charcoal_min.get();
            ConfigHandler.charcoal_max = (Integer)this.charcoal_max.get();
            ConfigHandler.charcoal_size = (Integer)this.charcoal_size.get();
            ConfigHandler.overworld_wub = (Boolean)this.overworld_wub.get();
            ConfigHandler.wub_block_count = (Integer)this.wub_block_count.get();
            ConfigHandler.wub_block_frequency = (Integer)this.wub_block_frequency.get();
            ConfigHandler.wub_block_min = (Integer)this.wub_block_min.get();
            ConfigHandler.wub_block_max = (Integer)this.wub_block_max.get();
            ConfigHandler.nether_wub = (Boolean)this.nether_wub.get();
            ConfigHandler.nether_wub_block_count = (Integer)this.nether_wub_block_count.get();
            ConfigHandler.nether_wub_block_frequency = (Integer)this.nether_wub_block_count.get();
            ConfigHandler.nether_wub_block_min = (Integer)this.nether_wub_block_min.get();
            ConfigHandler.nether_wub_block_max = (Integer)this.nether_wub_block_max.get();
            FuelHandler.tiny_charcoal_burntime = (Integer)this.tiny_charcoal_burntime.get();
            FuelHandler.tiny_coal_burntime = (Integer)this.tiny_coal_burntime.get();
            ConfigHandler.repair_tablet_cooldown = (Integer)this.repair_tablet_cooldown.get();
            ArmorHandler.lava_armor_resistance = (Boolean)this.lava_armor_resistance.get();
            ArmorHandler.lava_armor_resistance_lvl = (Integer)this.lava_armor_resistance_lvl.get();
            ArmorHandler.lava_armor_fire = (Boolean)this.lava_armor_fire.get();
            ArmorHandler.lava_armor_fire_lvl = (Integer)this.lava_armor_fire_lvl.get();
            ArmorHandler.dragon_fly = (Boolean)this.dragon_fly.get();
            ArmorHandler.dragon_resistance = (Boolean)this.dragon_resistance.get();
            ArmorHandler.dragon_resistance_lvl = (Integer)this.dragon_resistance_lvl.get();
            ArmorHandler.dragon_fire = (Boolean)this.dragon_fire.get();
            ArmorHandler.dragon_fire_lvl = (Integer)this.dragon_fire_lvl.get();
            ArmorHandler.dragon_strength = (Boolean)this.dragon_strength.get();
            ArmorHandler.dragon_strength_lvl = (Integer)this.dragon_strength_lvl.get();
            ArmorHandler.wither_resistance = (Boolean)this.wither_resistance.get();
            ArmorHandler.wither_resistance_lvl = (Integer)this.wither_resistance_lvl.get();
            ArmorHandler.wither_fire = (Boolean)this.wither_fire.get();
            ArmorHandler.wither_fire_lvl = (Integer)this.wither_fire_lvl.get();
            ArmorHandler.wither_strength = (Boolean)this.wither_strength.get();
            ArmorHandler.wither_strength_lvl = (Integer)this.wither_strength_lvl.get();
            ArmorHandler.lapis_armor_water = (Boolean)this.lapis_armor_water.get();
            ArmorHandler.lapis_armor_water_lvl = (Integer)this.lapis_armor_water_lvl.get();
            ArmorHandler.obsidian_armor_resistance = (Boolean)this.obsidian_armor_resistance.get();
            ArmorHandler.obsidian_armor_resistance_lvl = (Integer)this.obsidian_armor_resistance_lvl.get();
            ArmorHandler.quartz_armor_strength = (Boolean)this.quartz_armor_strength.get();
            ArmorHandler.quartz_armor_strength_lvl = (Integer)this.quartz_armor_strength_lvl.get();
            ArmorHandler.redstone_armor_speed = (Boolean)this.redstone_armor_speed.get();
            ArmorHandler.redstone_armor_speed_lvl = (Integer)this.redstone_armor_speed_lvl.get();
            ConfigHandler.spear_reach = ((Double)this.spear_reach.get()).floatValue();
            ConfigHandler.AppleAmount = (Integer)this.AppleAmount.get();
            ConfigHandler.AppleSaturation = ((Double)this.AppleSaturation.get()).floatValue();
            ConfigHandler.CarrotAmount = (Integer)this.CarrotAmount.get();
            ConfigHandler.CarrotSaturation = ((Double)this.CarrotSaturation.get()).floatValue();
            ConfigHandler.PotatoAmount = (Integer)this.PotatoAmount.get();
            ConfigHandler.PotatoSaturation = ((Double)this.PotatoSaturation.get()).floatValue();
            ConfigHandler.BeetAmount = (Integer)this.BeetAmount.get();
            ConfigHandler.BeetSaturation = ((Double)this.BeetSaturation.get()).floatValue();
            ConfigHandler.CactusAmount = (Integer)this.CactusAmount.get();
            ConfigHandler.CactusSaturation = ((Double)this.CactusSaturation.get()).floatValue();
            ConfigHandler.SlimeAmount = (Integer)this.SlimeAmount.get();
            ConfigHandler.SlimeSaturation = ((Double)this.SlimeSaturation.get()).floatValue();
            ConfigHandler.WheatAmount = (Integer)this.WheatAmount.get();
            ConfigHandler.WheatSaturation = ((Double)this.WheatSaturation.get()).floatValue();
            ConfigHandler.MelonAmount = (Integer)this.MelonAmount.get();
            ConfigHandler.MelonSaturation = ((Double)this.MelonSaturation.get()).floatValue();
            ConfigHandler.PumpkinAmount = (Integer)this.PumpkinAmount.get();
            ConfigHandler.PumpkinSaturation = ((Double)this.PumpkinSaturation.get()).floatValue();
            ConfigHandler.ExtraPlantGen = (Boolean)this.ExtraPlantGen.get();
            ConfigHandler.berryPlantRarity = (Integer)this.berryPlantRarity.get();
            ConfigHandler.BlueberryAmount = (Integer)this.BlueberryAmount.get();
            ConfigHandler.BlueberrySaturation = ((Double)this.BlueberrySaturation.get()).floatValue();
            ConfigHandler.BlackberryAmount = (Integer)this.BlackberryAmount.get();
            ConfigHandler.BlackberrySaturation = ((Double)this.BlackberrySaturation.get()).floatValue();
            ConfigHandler.MaloberryAmount = (Integer)this.MaloberryAmount.get();
            ConfigHandler.MaloberrySaturation = ((Double)this.MaloberrySaturation.get()).floatValue();
            ConfigHandler.RaspberryAmount = (Integer)this.RaspberryAmount.get();
            ConfigHandler.RaspberrySaturation = ((Double)this.RaspberrySaturation.get()).floatValue();
            ConfigHandler.ToastedAmount = (Integer)this.ToastedAmount.get();
            ConfigHandler.ToastedSaturation = ((Double)this.ToastedSaturation.get()).floatValue();
            ConfigHandler.eat_timer = (Integer)this.eat_timer.get();
            ConfigHandler.should_gen_quick_sand = (Boolean)this.quick_sand_generation.get();
            ConfigHandler.bushes_terrain_gen = (Boolean)this.berry_bushes_generation.get();
            ConfigHandler.wub_ore_gen = (Boolean)this.wub_ore_generation.get();
            ConfigHandler.charcoal_ore_gen = (Boolean)this.charcoal_ore_generation.get();
            ConfigHandler.ender_ore_gen = (Boolean)this.ender_ore_generation.get();
            ConfigHandler.lava_block_gen = (Boolean)this.lava_block_generation.get();
            ConfigHandler.water_block_gen = (Boolean)this.water_block_generation.get();
        }
    }
}

