/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.capabilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryStorage
extends ItemStackHandler {
    private final String name;

    public InventoryStorage(int inventorySize) {
        this("", inventorySize);
    }

    public InventoryStorage(String name, int inventorySize) {
        super(inventorySize);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasCustomName() {
        return this.name != null;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.name, new Object[0]);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.canInsertSlot(slot, stack)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack insertItemFirstAvaliableSlot(ItemStack stack, boolean simulate) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.insertItem(i, stack, true) == stack) continue;
            return this.insertItem(i, stack, false);
        }
        return stack;
    }

    public ItemStack getAndRemoveSlot(int slot) {
        ItemStack extract = this.getStackInSlot(slot).func_77946_l();
        if (!extract.func_190926_b()) {
            this.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        return extract;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canExtractSlot(slot)) {
            return super.extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
        return super.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    public boolean canExtractSlot(int slot) {
        return true;
    }

    public boolean canInsertSlot(int slot, ItemStack stack) {
        return true;
    }

    public void dropInventory(World world, BlockPos pos) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getAndRemoveSlot(i);
            if (stack.func_190926_b()) continue;
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), stack));
        }
    }

    public void writeToNBT(CompoundNBT compound) {
        compound.func_218657_a("Inventory", (INBT)this.serializeNBT());
    }

    public void readFromNBT(CompoundNBT compound) {
        this.deserializeNBT(compound.func_74775_l("Inventory"));
    }
}

