/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.blocks.growthblock;

import com.kashdeya.tinyprogressions.handlers.ConfigHandler;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.ticket.AABBTicket;

public class BlockGrowth
extends Block {
    private final int range;
    private final int rangeY;
    private final int growthLvl;
    private AABBTicket waterRegion;

    public BlockGrowth(Block.Properties prop, int level, int rangeX, int rangeY) {
        super(prop.func_200944_c().func_200948_a(8.0f, 1000.0f).func_200951_a(7).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        this.range = rangeX;
        this.rangeY = rangeY;
        this.growthLvl = level;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.makeWaterRegion(worldIn, pos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        this.removeWaterRegion();
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.removeWaterRegion();
    }

    private void makeWaterRegion(World worldIn, BlockPos pos) {
        if (this.growthLvl > 1 && !worldIn.field_72995_K) {
            this.waterRegion = FarmlandWaterManager.addAABBTicket((World)worldIn, (AxisAlignedBB)new AxisAlignedBB(pos).func_72321_a((double)(this.range * 2), (double)(this.rangeY * 2), (double)(this.range * 2)).func_72317_d((double)(-this.range), (double)(-this.range), (double)(-this.range)));
        }
    }

    private void removeWaterRegion() {
        if (this.waterRegion != null) {
            this.waterRegion.invalidate();
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (this.waterRegion == null) {
            this.makeWaterRegion((World)world, pos);
        }
        this.growCropsNearby(world, pos, state);
    }

    private int getGrowthCrystalTickRate() {
        int tickRate = this.growthLvl == 1 ? ConfigHandler.BlockGrowthTicks : (this.growthLvl == 2 ? ConfigHandler.BlockGrowthUpgradeTicks : (this.growthLvl == 3 ? ConfigHandler.BlockGrowthUpgradeTwoTicks : 40));
        return tickRate * 40;
    }

    private int getGrowthCrystalTickRate(double distanceCoefficient) {
        int tickRate = this.growthLvl == 1 ? ConfigHandler.BlockGrowthTicks : (this.growthLvl == 2 ? ConfigHandler.BlockGrowthUpgradeTicks : (this.growthLvl == 3 ? ConfigHandler.BlockGrowthUpgradeTwoTicks : 40));
        return (int)(distanceCoefficient * (double)tickRate * 40.0);
    }

    public void growCropsNearby(ServerWorld world, BlockPos pos, BlockState state) {
        int xO = pos.func_177958_n();
        int yO = pos.func_177956_o();
        int zO = pos.func_177952_p();
        for (int xD = -this.range; xD <= this.range; ++xD) {
            for (int yD = -this.rangeY; yD <= this.rangeY; ++yD) {
                for (int zD = -this.range; zD <= this.range; ++zD) {
                    int x = xO + xD;
                    int y = yO + yD;
                    int z = zO + zD;
                    double distance = Math.sqrt(Math.pow(x - xO, 2.0) + Math.pow(y - yO, 2.0) + Math.pow(z - zO, 2.0));
                    distance = Math.max(1.0, distance);
                    double distanceCoefficient = 1.0 - 1.0 / distance;
                    BlockPos curPos = new BlockPos(x, y, z);
                    BlockState cropState = world.func_180495_p(curPos);
                    Block cropBlock = cropState.func_177230_c();
                    if (!(cropBlock instanceof IPlantable) && !(cropBlock instanceof IGrowable) || cropBlock instanceof BlockGrowth) continue;
                    cropBlock.func_225534_a_(cropState, world, curPos, this.RANDOM);
                    if (world.func_205220_G_().func_205361_b(pos, (Object)this)) continue;
                    world.func_205220_G_().func_205360_a(pos, (Object)this, this.getGrowthCrystalTickRate(distanceCoefficient));
                }
            }
        }
        if (!world.func_205220_G_().func_205361_b(pos, (Object)this)) {
            world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), this.getGrowthCrystalTickRate());
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (ConfigHandler.ParticalTicks) {
            super.func_180655_c(stateIn, worldIn, pos, rand);
            for (int i = -4; i <= 4; ++i) {
                for (int j = -4; j <= 4; ++j) {
                    if (i > -4 && i < 4 && j == -2) {
                        j = 4;
                    }
                    if (rand.nextInt(ConfigHandler.GrowthParticalTicks) != 0) continue;
                    for (int k = 0; k <= 1; ++k) {
                        for (int xAxis = -this.range; xAxis <= this.range; ++xAxis) {
                            for (int zAxis = -this.range; zAxis <= this.range; ++zAxis) {
                                for (int yAxis = -this.rangeY; yAxis <= this.rangeY; ++yAxis) {
                                    BlockPos blockpos = pos.func_177982_a(i, k, j);
                                    Block checkBlock = worldIn.func_180495_p(blockpos.func_177982_a(xAxis, yAxis, zAxis)).func_177230_c();
                                    if (!(checkBlock instanceof IGrowable) && checkBlock != Blocks.field_150391_bh && checkBlock != Blocks.field_150434_aF && checkBlock != Blocks.field_196608_cF && checkBlock != Blocks.field_185766_cS) continue;
                                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat() - 1.0f), (double)((float)j + rand.nextFloat()) - 0.5);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        switch (this.growthLvl) {
            case 1: {
                tooltip.add(new TranslationTextComponent("tooltip.growth_1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                tooltip.add(new TranslationTextComponent("tooltip.growth_2", new Object[]{this.range + 1}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                tooltip.add(new TranslationTextComponent("tooltip.growth_3", new Object[]{this.rangeY}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                break;
            }
            case 2: {
                tooltip.add(new TranslationTextComponent("tooltip.growthupgrade_1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                tooltip.add(new TranslationTextComponent("tooltip.growth_2", new Object[]{this.range + 1}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                tooltip.add(new TranslationTextComponent("tooltip.growth_3", new Object[]{this.rangeY}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                tooltip.add(new TranslationTextComponent("tooltip.growthupgrade_4", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                tooltip.add(new TranslationTextComponent("tooltip.growthupgrade_5", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                break;
            }
            case 3: {
                tooltip.add(new TranslationTextComponent("tooltip.growthupgrade2_1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                tooltip.add(new TranslationTextComponent("tooltip.growth_2", new Object[]{this.range + 1}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                tooltip.add(new TranslationTextComponent("tooltip.growth_3", new Object[]{this.rangeY}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                tooltip.add(new TranslationTextComponent("tooltip.growthupgrade_4", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                tooltip.add(new TranslationTextComponent("tooltip.growthupgrade_5", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            }
        }
    }
}

