/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.blocks.cobblegen;

import com.kashdeya.tinyprogressions.blocks.StandardBlock;
import com.kashdeya.tinyprogressions.tiles.TileEntityCobblegen;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;

public class Cobblegen
extends StandardBlock {
    int cycleUpdate;
    int stackSize;

    public Cobblegen(int cycleUpdate, int stackSize, Block.Properties properties) {
        super(properties.func_200948_a(1.0f, 1000.0f).func_200951_a(1).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(1));
        this.cycleUpdate = cycleUpdate;
        this.stackSize = stackSize;
    }

    public boolean func_229869_c_(BlockState p_229869_1_, IBlockReader p_229869_2_, BlockPos p_229869_3_) {
        return false;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World worldIn, BlockPos pos, PlayerEntity player, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityCobblegen) {
            TileEntityCobblegen ttest = (TileEntityCobblegen)tile;
            if (!player.func_213453_ef()) {
                ItemStack stack = ttest.getInventory().getAndRemoveSlot(0);
                if (stack != null && !player.field_71071_by.func_70441_a(stack)) {
                    ForgeHooks.onPlayerTossEvent((PlayerEntity)player, (ItemStack)stack, (boolean)false);
                }
            } else {
                ItemStack stack = ttest.getInventory().getStackInSlot(0);
                player.func_145747_a((ITextComponent)new TranslationTextComponent(Blocks.field_150347_e.func_200291_n().getString() + " x " + (stack.func_190926_b() ? 0 : stack.func_190916_E()), new Object[0]));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState oldState, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (oldState.func_177230_c() != newState.func_177230_c() && (tile = worldIn.func_175625_s(pos)) != null && tile instanceof TileEntityCobblegen) {
            ((TileEntityCobblegen)tile).getInventory().dropInventory(worldIn, pos);
        }
        super.func_196243_a(oldState, worldIn, pos, newState, isMoving);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityCobblegen().setGenStats(this.cycleUpdate, this.stackSize);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("tooltip.cobblegen_1", new Object[]{this.stackSize}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        tooltip.add(new TranslationTextComponent("tooltip.cobblegen_2", new Object[]{this.cycleUpdate}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        tooltip.add(new TranslationTextComponent("tooltip.cobblegen_3", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        tooltip.add(new TranslationTextComponent("tooltip.cobblegen_4", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
    }
}

