/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.vulcanite.lootmodifiers;

import com.google.gson.JsonObject;
import insane96mcp.vulcanite.network.PacketBlockBreak;
import insane96mcp.vulcanite.network.PacketHandler;
import insane96mcp.vulcanite.setup.ModConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.ItemHandlerHelper;

public class SmeltingModifier
extends LootModifier {
    public SmeltingModifier(ILootCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
        generatedLoot.forEach(stack -> newLoot.add(SmeltingModifier.smelt(stack, context)));
        if (newLoot.equals(generatedLoot)) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (!(entity instanceof ServerPlayerEntity)) {
            throw new ClassCastException("Hope this isn't called other than the player breaking blocks " + entity.toString());
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        BlockPos pos = (BlockPos)context.func_216031_c(LootParameters.field_216286_f);
        PacketHandler.sendToClient(PacketDistributor.PLAYER.with(() -> player), new PacketBlockBreak(pos));
        if (player.field_71093_bK.func_186068_a() != -1) {
            player.func_184614_ca().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(Hand.MAIN_HAND));
        }
        if (((Boolean)ModConfig.COMMON.toolsAndWeapons.bonusStats.smeltingDropsExperience.get()).booleanValue()) {
            float experience = 0.0f;
            for (ItemStack stack2 : generatedLoot) {
                experience += SmeltingModifier.getExperience(stack2, context);
            }
            if (experience % 1.0f != 0.0f) {
                int intXp = (int)experience;
                float decimals = experience - (float)intXp;
                experience = context.func_216032_b().nextFloat() < decimals ? (float)Math.ceil(experience) : (float)Math.floor(experience);
            }
            if (experience > 0.0f) {
                ExperienceOrbEntity xpOrb = new ExperienceOrbEntity((World)context.func_202879_g(), (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), (int)experience);
                context.func_202879_g().func_217376_c((Entity)xpOrb);
            }
        }
        return newLoot;
    }

    private static ItemStack smelt(ItemStack stack, LootContext context) {
        return context.func_202879_g().func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), (World)context.func_202879_g()).map(AbstractCookingRecipe::func_77571_b).filter(itemStack -> !itemStack.func_190926_b()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.func_190916_E() * itemStack.func_190916_E()))).orElse(stack);
    }

    private static float getExperience(ItemStack stack, LootContext context) {
        return context.func_202879_g().func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), (World)context.func_202879_g()).map(AbstractCookingRecipe::func_222138_b).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SmeltingModifier> {
        public SmeltingModifier read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            return new SmeltingModifier(lootConditions);
        }
    }
}

