/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.vulcanite.integration;

import insane96mcp.vulcanite.events.AnvilUpdate;
import insane96mcp.vulcanite.setup.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("vulcanite", "vulcanite");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        this.registerVulcaniteToolForging(registration, factory);
    }

    private void registerVulcaniteToolForging(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        for (AnvilUpdate.EquipmentUpgrade upgrade : AnvilUpdate.EQUIPMENT_UPGRADES) {
            ItemStack equipment = new ItemStack((IItemProvider)upgrade.item);
            ItemStack nuggets = new ItemStack((IItemProvider)ModItems.VULCANITE_NUGGET.get(), upgrade.materialAmount);
            String itemName = upgrade.item.getRegistryName().func_110623_a();
            ResourceLocation vulcaniteName = new ResourceLocation("vulcanite", itemName.replace("iron", "vulcanite"));
            if (upgrade.item.equals(Items.field_151033_d)) {
                vulcaniteName = new ResourceLocation("vulcanite", "flint_and_vulcanite");
            }
            ItemStack output = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(vulcaniteName));
            recipes.add(factory.createAnvilRecipe(equipment, Collections.singletonList(nuggets), Collections.singletonList(output)));
        }
        registration.addRecipes(recipes, VanillaRecipeCategoryUid.ANVIL);
    }
}

