/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.vulcanite.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SolidifiedLavaBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    protected static final VoxelShape collisionShape = Block.func_208617_a((double)0.05, (double)0.05, (double)0.05, (double)15.95, (double)16.0, (double)15.95);
    public boolean flowing;

    public SolidifiedLavaBlock(boolean isFlowing) {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200944_c().func_200943_b(1.25f).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.flowing = isFlowing;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!this.tryMelt(state, (World)worldIn, pos)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.func_76136_a((Random)rand, (int)6, (int)12));
        }
    }

    private boolean tryMelt(BlockState state, World worldIn, BlockPos pos) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 3) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        if (!this.flowing) {
            worldIn.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        } else {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        return true;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.25f);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        int age = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)AGE);
        entity.func_70015_d(3 + age);
    }

    public void func_196262_a(BlockState state, World world, BlockPos blockPos, Entity entity) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        entity.func_70015_d(3 + age);
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return collisionShape;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        return 3 * (age + 1);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new IProperty[]{AGE}));
    }
}

