/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class MaterialCreator
extends BaseMekanismMaterial {
    private final BaseMekanismMaterial fallBack;
    private final CachedIntValue swordDamage;
    private final CachedFloatValue swordAtkSpeed;
    private final CachedFloatValue shovelDamage;
    private final CachedFloatValue shovelAtkSpeed;
    private final CachedFloatValue axeDamage;
    private final CachedFloatValue axeAtkSpeed;
    private final CachedIntValue pickaxeDamage;
    private final CachedFloatValue pickaxeAtkSpeed;
    private final CachedFloatValue hoeAtkSpeed;
    private final CachedIntValue paxelHarvestLevel;
    private final CachedFloatValue paxelDamage;
    private final CachedFloatValue paxelAtkSpeed;
    private final CachedFloatValue paxelEfficiency;
    private final CachedIntValue paxelEnchantability;
    private final CachedIntValue paxelMaxUses;
    private final CachedIntValue toolMaxUses;
    private final CachedFloatValue efficiency;
    private final CachedFloatValue attackDamage;
    private final CachedIntValue harvestLevel;
    private final CachedIntValue enchantability;
    private final CachedFloatValue toughness;
    private final CachedIntValue bootDurability;
    private final CachedIntValue leggingDurability;
    private final CachedIntValue chestplateDurability;
    private final CachedIntValue helmetDurability;
    private final CachedIntValue bootArmor;
    private final CachedIntValue leggingArmor;
    private final CachedIntValue chestplateArmor;
    private final CachedIntValue helmetArmor;

    public MaterialCreator(IMekanismConfig config, ForgeConfigSpec.Builder builder, BaseMekanismMaterial materialDefaults) {
        this.fallBack = materialDefaults;
        String toolKey = materialDefaults.getRegistryPrefix();
        builder.comment(" Material Settings for " + toolKey).push(toolKey);
        this.swordDamage = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + toolKey + " swords.").defineInRange(toolKey + "SwordDamage", materialDefaults.getSwordDamage(), 0, Integer.MAX_VALUE));
        this.swordAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + toolKey + " swords.").define(toolKey + "SwordAtkSpeed", (Object)materialDefaults.getSwordAtkSpeed()));
        this.shovelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + toolKey + " shovels.").defineInRange(toolKey + "ShovelDamage", (double)materialDefaults.getShovelDamage(), 0.0, 3.4028234663852886E38));
        this.shovelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + toolKey + " shovels.").define(toolKey + "ShovelAtkSpeed", (Object)materialDefaults.getShovelAtkSpeed()));
        this.axeDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + toolKey + " axes.").defineInRange(toolKey + "AxeDamage", (double)materialDefaults.getAxeDamage(), 0.0, 3.4028234663852886E38));
        this.axeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + toolKey + " axes.").define(toolKey + "AxeAtkSpeed", (Object)materialDefaults.getAxeAtkSpeed()));
        this.pickaxeDamage = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + toolKey + " pickaxes.").defineInRange(toolKey + "PickaxeDamage", materialDefaults.getPickaxeDamage(), 0, Integer.MAX_VALUE));
        this.pickaxeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + toolKey + " pickaxes.").define(toolKey + "PickaxeAtkSpeed", (Object)materialDefaults.getPickaxeAtkSpeed()));
        this.hoeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + toolKey + " hoes.").define(toolKey + "HoeAtkSpeed", (Object)materialDefaults.getHoeAtkSpeed()));
        this.toolMaxUses = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + toolKey + " tools.").defineInRange(toolKey + "ToolMaxUses", materialDefaults.func_200926_a(), 1, Integer.MAX_VALUE));
        this.efficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Efficiency of " + toolKey + " tools.").define(toolKey + "Efficiency", (Object)materialDefaults.func_200928_b()));
        this.paxelHarvestLevel = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Harvest level of " + toolKey + " paxels.").defineInRange(toolKey + "PaxelHarvestLevel", materialDefaults.getPaxelHarvestLevel(), 0, Integer.MAX_VALUE));
        this.paxelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + toolKey + " paxels.").defineInRange(toolKey + "PaxelDamage", (double)materialDefaults.getPaxelDamage(), 0.0, 3.4028234663852886E38));
        this.paxelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + toolKey + " paxels.").define(toolKey + "PaxelAtkSpeed", (Object)materialDefaults.getPaxelAtkSpeed()));
        this.paxelEfficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Efficiency of " + toolKey + " paxels.").define(toolKey + "PaxelEfficiency", (Object)materialDefaults.getPaxelEfficiency()));
        this.paxelEnchantability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Natural enchantability factor of " + toolKey + " paxels.").defineInRange(toolKey + "PaxelEnchantability", materialDefaults.getPaxelEnchantability(), 0, Integer.MAX_VALUE));
        this.paxelMaxUses = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + toolKey + " paxels.").defineInRange(toolKey + "PaxelMaxUses", materialDefaults.getPaxelMaxUses(), 1, Integer.MAX_VALUE));
        this.attackDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Base attack damage of " + toolKey + " items.").defineInRange(toolKey + "AttackDamage", (double)materialDefaults.func_200929_c(), 0.0, 3.4028234663852886E38));
        this.harvestLevel = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Harvest level of " + toolKey + " tools.").defineInRange(toolKey + "HarvestLevel", materialDefaults.func_200925_d(), 0, Integer.MAX_VALUE));
        this.enchantability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Natural enchantability factor of " + toolKey + " items.").defineInRange(toolKey + "Enchantability", materialDefaults.getCommonEnchantability(), 0, Integer.MAX_VALUE));
        this.toughness = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Base armor toughness value of " + toolKey + " armor.").defineInRange(toolKey + "Toughness", (double)materialDefaults.func_200901_e(), 0.0, 3.4028234663852886E38));
        this.bootDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + toolKey + " boots.").defineInRange(toolKey + "BootDurability", materialDefaults.func_200896_a(EquipmentSlotType.FEET), 1, Integer.MAX_VALUE));
        this.leggingDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + toolKey + " leggings.").defineInRange(toolKey + "LeggingDurability", materialDefaults.func_200896_a(EquipmentSlotType.LEGS), 1, Integer.MAX_VALUE));
        this.chestplateDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + toolKey + " chestplates.").defineInRange(toolKey + "ChestplateDurability", materialDefaults.func_200896_a(EquipmentSlotType.CHEST), 1, Integer.MAX_VALUE));
        this.helmetDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + toolKey + " helmets.").defineInRange(toolKey + "HelmetDurability", materialDefaults.func_200896_a(EquipmentSlotType.HEAD), 1, Integer.MAX_VALUE));
        this.bootArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + toolKey + " boots.").defineInRange(toolKey + "BootArmor", materialDefaults.func_200902_b(EquipmentSlotType.FEET), 0, Integer.MAX_VALUE));
        this.leggingArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + toolKey + " leggings.").defineInRange(toolKey + "LeggingArmor", materialDefaults.func_200902_b(EquipmentSlotType.LEGS), 0, Integer.MAX_VALUE));
        this.chestplateArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + toolKey + " chestplates.").defineInRange(toolKey + "ChestplateArmor", materialDefaults.func_200902_b(EquipmentSlotType.CHEST), 0, Integer.MAX_VALUE));
        this.helmetArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + toolKey + " helmets.").defineInRange(toolKey + "HelmetArmor", materialDefaults.func_200902_b(EquipmentSlotType.HEAD), 0, Integer.MAX_VALUE));
        builder.pop();
    }

    @Override
    public int getSwordDamage() {
        return this.swordDamage.get();
    }

    @Override
    public float getSwordAtkSpeed() {
        return this.swordAtkSpeed.get();
    }

    @Override
    public float getShovelDamage() {
        return this.shovelDamage.get();
    }

    @Override
    public float getShovelAtkSpeed() {
        return this.shovelAtkSpeed.get();
    }

    @Override
    public float getAxeDamage() {
        return this.axeDamage.get();
    }

    @Override
    public float getAxeAtkSpeed() {
        return this.axeAtkSpeed.get();
    }

    @Override
    public int getPickaxeDamage() {
        return this.pickaxeDamage.get();
    }

    @Override
    public float getPickaxeAtkSpeed() {
        return this.pickaxeAtkSpeed.get();
    }

    @Override
    public float getHoeAtkSpeed() {
        return this.hoeAtkSpeed.get();
    }

    @Override
    public int getPaxelHarvestLevel() {
        return this.paxelHarvestLevel.get();
    }

    @Override
    public int getPaxelMaxUses() {
        return this.paxelMaxUses.get();
    }

    @Override
    public float getPaxelEfficiency() {
        return this.paxelEfficiency.get();
    }

    @Override
    public float getPaxelDamage() {
        return this.paxelDamage.get();
    }

    @Override
    public float getPaxelAtkSpeed() {
        return this.paxelAtkSpeed.get();
    }

    public int func_200926_a() {
        return this.toolMaxUses.get();
    }

    public float func_200928_b() {
        return this.efficiency.get();
    }

    public float func_200929_c() {
        return this.attackDamage.get();
    }

    public int func_200925_d() {
        return this.harvestLevel.get();
    }

    public int func_200896_a(EquipmentSlotType slotType) {
        switch (slotType) {
            case FEET: {
                return this.bootDurability.get();
            }
            case LEGS: {
                return this.leggingDurability.get();
            }
            case CHEST: {
                return this.chestplateDurability.get();
            }
            case HEAD: {
                return this.helmetDurability.get();
            }
        }
        return this.fallBack.func_200896_a(slotType);
    }

    public int func_200902_b(EquipmentSlotType slotType) {
        switch (slotType) {
            case FEET: {
                return this.bootArmor.get();
            }
            case LEGS: {
                return this.leggingArmor.get();
            }
            case CHEST: {
                return this.chestplateArmor.get();
            }
            case HEAD: {
                return this.helmetArmor.get();
            }
        }
        return this.fallBack.func_200902_b(slotType);
    }

    @Override
    public int getCommonEnchantability() {
        return this.enchantability.get();
    }

    public float func_200901_e() {
        return this.toughness.get();
    }

    @Nonnull
    public SoundEvent func_200899_b() {
        return this.fallBack.func_200899_b();
    }

    @Override
    @Nonnull
    public Ingredient getCommonRepairMaterial() {
        return this.fallBack.getCommonRepairMaterial();
    }

    @Override
    @Nonnull
    public String func_200897_d() {
        return this.fallBack.func_200897_d();
    }

    @Override
    @Nonnull
    public String getRegistryPrefix() {
        return this.fallBack.getRegistryPrefix();
    }

    @Override
    public int getPaxelEnchantability() {
        return this.paxelEnchantability.get();
    }
}

