/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.tools.common.material.BaseMekanismMaterial;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.material.impl.BronzeMaterialDefaults;
import mekanism.tools.common.material.impl.LapisLazuliMaterialDefaults;
import mekanism.tools.common.material.impl.OsmiumMaterialDefaults;
import mekanism.tools.common.material.impl.RefinedGlowstoneMaterialDefaults;
import mekanism.tools.common.material.impl.RefinedObsidianMaterialDefaults;
import mekanism.tools.common.material.impl.SteelMaterialDefaults;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ToolsConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedDoubleValue armorSpawnRate;
    public final BaseMekanismMaterial bronze;
    public final BaseMekanismMaterial lapisLazuli;
    public final BaseMekanismMaterial osmium;
    public final BaseMekanismMaterial refinedGlowstone;
    public final BaseMekanismMaterial refinedObsidian;
    public final BaseMekanismMaterial steel;

    ToolsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Tools Config. This config is synced from server to client.").push("tools");
        this.armorSpawnRate = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that Mekanism Armor can spawn on mobs.").defineInRange("mobArmorSpawnRate", 0.03, 0.0, 1.0));
        this.bronze = new MaterialCreator((IMekanismConfig)this, builder, new BronzeMaterialDefaults());
        this.lapisLazuli = new MaterialCreator((IMekanismConfig)this, builder, new LapisLazuliMaterialDefaults());
        this.osmium = new MaterialCreator((IMekanismConfig)this, builder, new OsmiumMaterialDefaults());
        this.refinedGlowstone = new MaterialCreator((IMekanismConfig)this, builder, new RefinedGlowstoneMaterialDefaults());
        this.refinedObsidian = new MaterialCreator((IMekanismConfig)this, builder, new RefinedObsidianMaterialDefaults());
        this.steel = new MaterialCreator((IMekanismConfig)this, builder, new SteelMaterialDefaults());
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "tools";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

