/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import squeek.appleskin.ModConfig;
import squeek.appleskin.ModInfo;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.HungerHelper;

@OnlyIn(value=Dist.CLIENT)
public class HUDOverlayHandler {
    private float flashAlpha = 0.0f;
    private byte alphaDir = 1;
    protected int foodIconsOffset;
    private static final ResourceLocation modIcons = new ResourceLocation(ModInfo.MODID_LOWER, "textures/icons.png");

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new HUDOverlayHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPreRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        this.foodIconsOffset = ForgeIngameGui.right_height;
        if (event.isCanceled()) {
            return;
        }
        if (!((Boolean)ModConfig.SHOW_FOOD_EXHAUSTION_UNDERLAY.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        int left = mc.func_228018_at_().func_198107_o() / 2 + 91;
        int top = mc.func_228018_at_().func_198087_p() - this.foodIconsOffset;
        HUDOverlayHandler.drawExhaustionOverlay(HungerHelper.getExhaustion((PlayerEntity)player), mc, left, top, 1.0f);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY.get()).booleanValue() && !((Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ItemStack heldItem = player.func_184614_ca();
        if (!FoodHelper.isFood(heldItem)) {
            heldItem = player.func_184592_cb();
        }
        FoodStats stats = player.func_71024_bL();
        int left = mc.func_228018_at_().func_198107_o() / 2 + 91;
        int top = mc.func_228018_at_().func_198087_p() - this.foodIconsOffset;
        if (((Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get()).booleanValue()) {
            HUDOverlayHandler.drawSaturationOverlay(0.0f, stats.func_75115_e(), mc, left, top, 1.0f);
        }
        if (!((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY.get()).booleanValue() || heldItem.func_190926_b() || !FoodHelper.isFood(heldItem)) {
            this.flashAlpha = 0.0f;
            this.alphaDir = 1;
            return;
        }
        FoodHelper.BasicFoodValues foodValues = FoodHelper.getModifiedFoodValues(heldItem, (PlayerEntity)player);
        HUDOverlayHandler.drawHungerOverlay(foodValues.hunger, stats.func_75116_a(), mc, left, top, this.flashAlpha, FoodHelper.isRotten(heldItem));
        if (((Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get()).booleanValue()) {
            int newFoodValue = stats.func_75116_a() + foodValues.hunger;
            float newSaturationValue = stats.func_75115_e() + foodValues.getSaturationIncrement();
            HUDOverlayHandler.drawSaturationOverlay(newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.func_75115_e() : foodValues.getSaturationIncrement(), stats.func_75115_e(), mc, left, top, this.flashAlpha);
        }
    }

    public static void drawSaturationOverlay(float saturationGained, float saturationLevel, Minecraft mc, int left, int top, float alpha) {
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        int startBar = saturationGained != 0.0f ? Math.max(0, (int)saturationLevel / 2) : 0;
        int endBar = (int)Math.ceil(Math.min(20.0f, saturationLevel + saturationGained) / 2.0f);
        int barsNeeded = endBar - startBar;
        mc.func_110434_K().func_110577_a(modIcons);
        HUDOverlayHandler.enableAlpha(alpha);
        for (int i = startBar; i < startBar + barsNeeded; ++i) {
            int x = left - i * 8 - 9;
            int y = top;
            float effectiveSaturationOfBar = (saturationLevel + saturationGained) / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                mc.field_71456_v.blit(x, y, 27, 0, 9, 9);
                continue;
            }
            if ((double)effectiveSaturationOfBar > 0.5) {
                mc.field_71456_v.blit(x, y, 18, 0, 9, 9);
                continue;
            }
            if ((double)effectiveSaturationOfBar > 0.25) {
                mc.field_71456_v.blit(x, y, 9, 0, 9, 9);
                continue;
            }
            if (!(effectiveSaturationOfBar > 0.0f)) continue;
            mc.field_71456_v.blit(x, y, 0, 0, 9, 9);
        }
        HUDOverlayHandler.disableAlpha(alpha);
        mc.func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
    }

    public static void drawHungerOverlay(int hungerRestored, int foodLevel, Minecraft mc, int left, int top, float alpha, boolean useRottenTextures) {
        if (hungerRestored == 0) {
            return;
        }
        int startBar = foodLevel / 2;
        int endBar = (int)Math.ceil((float)Math.min(20, foodLevel + hungerRestored) / 2.0f);
        int barsNeeded = endBar - startBar;
        mc.func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
        HUDOverlayHandler.enableAlpha(alpha);
        for (int i = startBar; i < startBar + barsNeeded; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int icon = 16;
            int background = 1;
            if (useRottenTextures) {
                icon += 36;
                background = 13;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.1f));
            mc.field_71456_v.blit(x, y, 16 + background * 9, 27, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (idx < foodLevel + hungerRestored) {
                mc.field_71456_v.blit(x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (idx != foodLevel + hungerRestored) continue;
            mc.field_71456_v.blit(x, y, icon + 45, 27, 9, 9);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawExhaustionOverlay(float exhaustion, Minecraft mc, int left, int top, float alpha) {
        mc.func_110434_K().func_110577_a(modIcons);
        float maxExhaustion = HungerHelper.getMaxExhaustion((PlayerEntity)mc.field_71439_g);
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        HUDOverlayHandler.enableAlpha(0.75f);
        mc.field_71456_v.blit(left - width, top, 81 - width, 18, width, height);
        HUDOverlayHandler.disableAlpha(0.75f);
        mc.func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
    }

    public static void enableAlpha(float alpha) {
        RenderSystem.enableBlend();
        if (alpha == 1.0f) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public static void disableAlpha(float alpha) {
        RenderSystem.disableBlend();
        if (alpha == 1.0f) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.flashAlpha += (float)this.alphaDir * 0.125f;
        if (this.flashAlpha >= 1.5f) {
            this.flashAlpha = 1.0f;
            this.alphaDir = (byte)-1;
        } else if (this.flashAlpha <= -0.5f) {
            this.flashAlpha = 0.0f;
            this.alphaDir = 1;
        }
    }
}

