/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.world.gen.FairyRingGenerator;

@LoadModule(category=ModuleCategory.BUILDING)
public class FairyRingsModule
extends Module {
    @Config
    public static double forestChance = 0.00625;
    @Config
    public static double plainsChance = 0.0025;
    @Config
    public static DimensionConfig dimensions = new DimensionConfig(false, "minecraft:overworld");
    @Config(name="Ores")
    public static List<String> oresRaw = Lists.newArrayList((Object[])new String[]{"minecraft:emerald_ore", "minecraft:diamond_ore"});
    public static List<BlockState> ores;

    @Override
    public void setup() {
        WorldGenHandler.addGenerator(this, new FairyRingGenerator(dimensions), GenerationStage.Decoration.TOP_LAYER_MODIFICATION, 0);
    }

    @Override
    public void configChanged() {
        ores = new ArrayList<BlockState>();
        for (String s : oresRaw) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
            if (b == null) {
                new IllegalArgumentException("Block " + s + " does not exist!").printStackTrace();
                continue;
            }
            ores.add(b.func_176223_P());
        }
    }
}

