/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.world.config.BigStoneClusterConfig;
import vazkii.quark.world.gen.BigStoneClusterGenerator;
import vazkii.quark.world.module.NewStoneTypesModule;

@LoadModule(category=ModuleCategory.WORLD)
public class BigStoneClustersModule
extends Module {
    @Config
    public static BigStoneClusterConfig granite = new BigStoneClusterConfig(false, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
    @Config
    public static BigStoneClusterConfig diorite = new BigStoneClusterConfig(false, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MUSHROOM);
    @Config
    public static BigStoneClusterConfig andesite = new BigStoneClusterConfig(false, BiomeDictionary.Type.FOREST);
    @Config
    public static BigStoneClusterConfig marble = new BigStoneClusterConfig(false, BiomeDictionary.Type.PLAINS);
    @Config
    public static BigStoneClusterConfig limestone = new BigStoneClusterConfig(false, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.OCEAN);
    @Config
    public static BigStoneClusterConfig jasper = new BigStoneClusterConfig(false, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY);
    @Config
    public static BigStoneClusterConfig slate = new BigStoneClusterConfig(false, BiomeDictionary.Type.COLD);
    @Config
    public static BigStoneClusterConfig basalt = new BigStoneClusterConfig(true, 19, 6, 20, 20, 120, BiomeDictionary.Type.NETHER);
    @Config
    public static List<String> blocksToReplace = Lists.newArrayList((Object[])new String[]{"minecraft:stone", "minecraft:andesite", "minecraft:diorite", "minecraft:granite", "minecraft:netherrack", "minecraft:end_stone", "quark:marble", "quark:limestone", "quark:jasper", "quark:slate", "quark:basalt"});
    public static Predicate<Block> blockReplacePredicate = Predicates.alwaysFalse();

    @Override
    public void setup() {
        BooleanSupplier alwaysTrue = () -> true;
        this.add(granite, Blocks.field_196650_c, alwaysTrue);
        this.add(diorite, Blocks.field_196654_e, alwaysTrue);
        this.add(andesite, Blocks.field_196656_g, alwaysTrue);
        this.add(marble, NewStoneTypesModule.marbleBlock, () -> NewStoneTypesModule.enableMarble);
        this.add(limestone, NewStoneTypesModule.limestoneBlock, () -> NewStoneTypesModule.enableLimestone);
        this.add(jasper, NewStoneTypesModule.jasperBlock, () -> NewStoneTypesModule.enableJasper);
        this.add(slate, NewStoneTypesModule.slateBlock, () -> NewStoneTypesModule.enableSlate);
        this.add(basalt, NewStoneTypesModule.basaltBlock, () -> NewStoneTypesModule.enableBasalt);
        this.conditionalize(Blocks.field_196650_c, () -> !this.enabled || !BigStoneClustersModule.granite.enabled);
        this.conditionalize(Blocks.field_196654_e, () -> !this.enabled || !BigStoneClustersModule.diorite.enabled);
        this.conditionalize(Blocks.field_196656_g, () -> !this.enabled || !BigStoneClustersModule.andesite.enabled);
    }

    private void add(BigStoneClusterConfig config, Block block, BooleanSupplier condition) {
        WorldGenHandler.addGenerator(this, new BigStoneClusterGenerator(config, block.func_176223_P(), condition), GenerationStage.Decoration.UNDERGROUND_DECORATION, 0);
    }

    private void conditionalize(Block block, BooleanSupplier condition) {
        BiPredicate<Feature<? extends IFeatureConfig>, IFeatureConfig> pred = (feature, config) -> {
            if (config instanceof OreFeatureConfig) {
                OreFeatureConfig oconfig = (OreFeatureConfig)config;
                return oconfig.field_202444_d.func_177230_c() == block;
            }
            return false;
        };
        WorldGenHandler.conditionalizeFeatures(GenerationStage.Decoration.UNDERGROUND_ORES, pred, condition);
    }

    @Override
    public void configChanged() {
        blockReplacePredicate = Predicates.alwaysFalse();
        for (String s : blocksToReplace) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
            if (b == null || b == Blocks.field_150350_a) continue;
            blockReplacePredicate = blockReplacePredicate.or((Predicate<Block>)Predicates.equalTo((Object)b));
        }
    }
}

