/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen.underground;

import it.unimi.dsi.fastutil.ints.Int2ByteArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import vazkii.quark.world.gen.UndergroundBiomeGenerator;
import vazkii.quark.world.gen.underground.BasicUndergroundBiome;
import vazkii.quark.world.module.underground.CaveCrystalUndergroundBiomeModule;

public class CaveCrystalUndergroundBiome
extends BasicUndergroundBiome {
    private static final Int2ByteMap CRYSTAL_DATA = new Int2ByteArrayMap();
    private final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    private final BlockState STONE = Blocks.field_150348_b.func_176223_P();

    public CaveCrystalUndergroundBiome() {
        super(Blocks.field_150350_a.func_176223_P(), Blocks.field_150348_b.func_176223_P(), Blocks.field_150348_b.func_176223_P());
    }

    @Override
    public void fillCeiling(UndergroundBiomeGenerator.Context context, BlockPos pos, BlockState state) {
        int floorIdx;
        byte raw = CaveCrystalUndergroundBiome.calculateRawColorData(context.source);
        int ceilIdx = raw >> 4 & 0xF;
        if (ceilIdx >= (floorIdx = raw & 0xF)) {
            ++ceilIdx;
        }
        if (context.random.nextDouble() < CaveCrystalUndergroundBiomeModule.crystalSpawnChance) {
            BlockPos floorPos = pos.func_177977_b();
            while (context.world.func_175623_d(floorPos)) {
                floorPos = floorPos.func_177977_b();
            }
            if (!context.world.func_180495_p(pos).func_203425_a(CaveCrystalUndergroundBiomeModule.crystalTag)) {
                int dist = pos.func_177956_o() - floorPos.func_177956_o();
                int start = 0;
                if (!STONE_TYPES_MATCHER.test(context.world.func_180495_p(pos.func_177984_a()))) {
                    ++start;
                }
                BlockState crystalState = CaveCrystalUndergroundBiomeModule.crystal(ceilIdx).func_176223_P();
                for (int i = start; i <= dist * 3 / 4; ++i) {
                    context.world.func_180501_a(pos.func_177967_a(Direction.DOWN, i), crystalState, 2);
                }
            }
        }
    }

    @Override
    public void fillFloor(UndergroundBiomeGenerator.Context context, BlockPos pos, BlockState state) {
        byte raw = CaveCrystalUndergroundBiome.calculateRawColorData(context.source);
        int floorIdx = raw & 0xF;
        if (context.random.nextDouble() < CaveCrystalUndergroundBiomeModule.crystalSpawnChance) {
            BlockPos ceilPos = pos.func_177984_a();
            while (context.world.func_175623_d(ceilPos)) {
                ceilPos = ceilPos.func_177984_a();
            }
            if (!context.world.func_180495_p(pos).func_203425_a(CaveCrystalUndergroundBiomeModule.crystalTag)) {
                int dist = ceilPos.func_177956_o() - pos.func_177956_o();
                int start = 0;
                if (!STONE_TYPES_MATCHER.test(context.world.func_180495_p(pos.func_177977_b()))) {
                    ++start;
                }
                BlockState crystalState = CaveCrystalUndergroundBiomeModule.crystal(floorIdx).func_176223_P();
                for (int i = start; i <= dist * 3 / 4; ++i) {
                    context.world.func_180501_a(pos.func_177967_a(Direction.UP, i), crystalState, 2);
                }
                return;
            }
        }
        if (CaveCrystalUndergroundBiomeModule.crystalsGrowInLava) {
            context.world.func_180501_a(pos, this.LAVA, 2);
            for (Direction dir : Direction.values()) {
                BlockPos shiftPos;
                if (dir == Direction.UP || context.world.func_180495_p(shiftPos = pos.func_177972_a(dir)).func_224755_d((IBlockReader)context.world, shiftPos, dir.func_176734_d())) continue;
                context.world.func_180501_a(shiftPos, this.STONE, 2);
            }
        }
    }

    private static byte calculateRawColorData(BlockPos source) {
        return CRYSTAL_DATA.computeIfAbsent(source.hashCode(), src -> {
            Random rand = new Random(src);
            return (byte)(rand.nextInt(8) << 4 | rand.nextInt(9));
        });
    }
}

