/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import vazkii.quark.oddities.tile.MatrixEnchantingTableTileEntity;

public class MatrixEnchantingTableTileEntityRenderer
extends TileEntityRenderer<MatrixEnchantingTableTileEntity> {
    public static final Material TEXTURE_BOOK = new Material(AtlasTexture.field_110575_b, new ResourceLocation("entity/enchanting_table_book"));
    private final BookModel modelBook = new BookModel();

    public MatrixEnchantingTableTileEntityRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    public void render(MatrixEnchantingTableTileEntity te, float pticks, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        float time = (float)te.tickCount + pticks;
        float f1 = te.bookRotation - te.bookRotationPrev;
        while ((double)f1 >= Math.PI) {
            f1 = (float)((double)f1 - Math.PI * 2);
        }
        while ((double)f1 < -Math.PI) {
            f1 = (float)((double)f1 + Math.PI * 2);
        }
        float rot = te.bookRotationPrev + f1 * pticks;
        float bookOpen = te.bookSpreadPrev + (te.bookSpread - te.bookSpreadPrev) * pticks;
        this.renderBook(te, time, rot, pticks, matrix, buffer, light, overlay);
        ItemStack item = te.func_70301_a(0);
        if (!item.func_190926_b()) {
            this.renderItem(item, time, bookOpen, rot, matrix, buffer, light, overlay);
        }
    }

    private void renderItem(ItemStack item, float time, float bookOpen, float rot, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, (double)0.8f, 0.5);
        matrix.func_227862_a_(0.6f, 0.6f, 0.6f);
        rot *= -57.295776f;
        rot -= 90.0f;
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rot *= bookOpen));
        matrix.func_227861_a_(0.0, (double)(bookOpen * 1.4f), Math.sin((double)bookOpen * Math.PI));
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f * (bookOpen - 1.0f)));
        float trans = (float)Math.sin((double)time * 0.06) * bookOpen * 0.2f;
        matrix.func_227861_a_(0.0, (double)trans, 0.0);
        ItemRenderer render = Minecraft.func_71410_x().func_175599_af();
        render.func_229110_a_(item, ItemCameraTransforms.TransformType.FIXED, light, overlay, matrix, buffer);
        matrix.func_227865_b_();
    }

    private void renderBook(MatrixEnchantingTableTileEntity tileEntityIn, float time, float bookRot, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float f1;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.75, 0.5);
        float f = (float)tileEntityIn.tickCount + partialTicks;
        matrixStackIn.func_227861_a_(0.0, (double)(0.1f + MathHelper.func_76126_a((float)(f * 0.1f)) * 0.01f), 0.0);
        for (f1 = tileEntityIn.bookRotation - tileEntityIn.bookRotationPrev; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        float f2 = tileEntityIn.bookRotationPrev + f1 * partialTicks;
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-f2));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(80.0f));
        float f3 = MathHelper.func_219799_g((float)partialTicks, (float)tileEntityIn.pageFlipPrev, (float)tileEntityIn.pageFlip);
        float f4 = MathHelper.func_226164_h_((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = MathHelper.func_226164_h_((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)tileEntityIn.bookSpreadPrev, (float)tileEntityIn.bookSpread);
        this.modelBook.func_228247_a_(f, MathHelper.func_76131_a((float)f4, (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)f5, (float)0.0f, (float)1.0f), f6);
        IVertexBuilder ivertexbuilder = TEXTURE_BOOK.func_229311_a_(bufferIn, RenderType::func_228634_a_);
        this.modelBook.func_228249_b_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }
}

