/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.block;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.items.CapabilityItemHandler;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.Module;
import vazkii.quark.oddities.tile.PipeTileEntity;

public class PipeBlock
extends QuarkBlock
implements IWaterLoggable {
    private static final VoxelShape CENTER_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape DOWN_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape UP_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)1.0);
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875);
    public static final EnumProperty<ConnectionType> DOWN = EnumProperty.func_177709_a((String)"down", ConnectionType.class);
    public static final EnumProperty<ConnectionType> UP = EnumProperty.func_177709_a((String)"up", ConnectionType.class);
    public static final EnumProperty<ConnectionType> NORTH = EnumProperty.func_177709_a((String)"north", ConnectionType.class);
    public static final EnumProperty<ConnectionType> SOUTH = EnumProperty.func_177709_a((String)"south", ConnectionType.class);
    public static final EnumProperty<ConnectionType> WEST = EnumProperty.func_177709_a((String)"west", ConnectionType.class);
    public static final EnumProperty<ConnectionType> EAST = EnumProperty.func_177709_a((String)"east", ConnectionType.class);
    public static final BooleanProperty ENABLED = BooleanProperty.func_177716_a((String)"enabled");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final EnumProperty<ConnectionType>[] CONNECTIONS = new EnumProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private static final VoxelShape[] SIDE_BOXES = new VoxelShape[]{DOWN_SHAPE, UP_SHAPE, NORTH_SHAPE, SOUTH_SHAPE, WEST_SHAPE, EAST_SHAPE};
    private static final VoxelShape[] shapeCache = new VoxelShape[64];
    private static final Map<BlockState, Direction> FLARE_STATES = Maps.newHashMap();

    public PipeBlock(Module module) {
        super("pipe", module, ItemGroup.field_78028_d, Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(DOWN, (Comparable)((Object)ConnectionType.NONE))).func_206870_a(UP, (Comparable)((Object)ConnectionType.NONE))).func_206870_a(NORTH, (Comparable)((Object)ConnectionType.NONE))).func_206870_a(SOUTH, (Comparable)((Object)ConnectionType.NONE))).func_206870_a(WEST, (Comparable)((Object)ConnectionType.NONE))).func_206870_a(EAST, (Comparable)((Object)ConnectionType.NONE))).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        block0: for (BlockState state : this.field_176227_L.func_177619_a()) {
            Direction onlySide = null;
            for (Direction facing : Direction.values()) {
                if (state.func_177229_b(CONNECTIONS[facing.func_176745_a()]) == ConnectionType.NONE) continue;
                if (onlySide != null) continue block0;
                onlySide = facing;
            }
            if (onlySide == null) continue;
            FLARE_STATES.put(state, onlySide.func_176734_d());
        }
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.PICKAXE;
    }

    @Nonnull
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState targetState = this.getTargetState(worldIn, pos, (Boolean)state.func_177229_b((IProperty)WATERLOGGED));
        if (!targetState.equals(state)) {
            worldIn.func_180501_a(pos, targetState, 6);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getTargetState(context.func_195991_k(), context.func_195995_a(), context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a);
    }

    private BlockState getTargetState(World worldIn, BlockPos pos, boolean waterlog) {
        BlockState newState = this.func_176223_P();
        newState = (BlockState)((BlockState)newState.func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(!worldIn.func_175640_z(pos)))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(waterlog));
        for (Direction facing : Direction.values()) {
            EnumProperty<ConnectionType> prop = CONNECTIONS[facing.ordinal()];
            ConnectionType type = this.getConnectionTo((IBlockReader)worldIn, pos, facing);
            newState = (BlockState)newState.func_206870_a(prop, (Comparable)((Object)type));
        }
        return newState;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int index = 0;
        for (Direction dir : Direction.values()) {
            int ord = dir.ordinal();
            if (!((ConnectionType)((Object)state.func_177229_b(PipeBlock.CONNECTIONS[ord]))).isSolid) continue;
            index += 1 << ord;
        }
        VoxelShape cached = shapeCache[index];
        if (cached == null) {
            VoxelShape currShape = CENTER_SHAPE;
            for (Direction dir : Direction.values()) {
                ConnectionType type = PipeBlock.getType(state, dir);
                if (type == null || !type.isSolid) continue;
                currShape = VoxelShapes.func_197872_a((VoxelShape)currShape, (VoxelShape)SIDE_BOXES[dir.ordinal()]);
            }
            PipeBlock.shapeCache[index] = currShape;
            cached = currShape;
        }
        return cached;
    }

    public static ConnectionType getType(BlockState state, Direction side) {
        if (FLARE_STATES.containsKey(state) && FLARE_STATES.get(state) == side) {
            return null;
        }
        EnumProperty<ConnectionType> prop = CONNECTIONS[side.ordinal()];
        return (ConnectionType)((Object)state.func_177229_b(prop));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{UP, DOWN, NORTH, SOUTH, WEST, EAST, ENABLED, WATERLOGGED});
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof PipeTileEntity) {
            return ((PipeTileEntity)tile).getComparatorOutput();
        }
        return 0;
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof PipeTileEntity) {
            ((PipeTileEntity)tileentity).dropAllItems();
        }
        super.func_176206_d(worldIn, pos, state);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PipeTileEntity();
    }

    private ConnectionType getConnectionTo(IBlockReader world, BlockPos pos, Direction face) {
        TileEntity tile = world.func_175625_s(pos = pos.func_177972_a(face));
        if (tile != null) {
            if (tile instanceof PipeTileEntity) {
                return ConnectionType.PIPE;
            }
            if (tile instanceof IInventory || tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()).isPresent()) {
                return ConnectionType.TERMINAL;
            }
        }
        BlockState stateAt = world.func_180495_p(pos);
        Block blockAt = stateAt.func_177230_c();
        if (face.func_176740_k() == Direction.Axis.Y && blockAt.func_203417_a(BlockTags.field_219757_z) || (blockAt instanceof PistonBlock || blockAt instanceof PistonHeadBlock) && stateAt.func_177229_b((IProperty)DirectionalBlock.field_176387_N) == face.func_176734_d()) {
            return ConnectionType.PROP;
        }
        return ConnectionType.NONE;
    }

    public static enum ConnectionType implements IStringSerializable
    {
        NONE(false, false, false),
        PIPE(true, true, false),
        TERMINAL(true, true, true),
        PROP(true, false, false);

        public final boolean isSolid;
        public final boolean allowsItems;
        public final boolean isFlared;

        private ConnectionType(boolean isSolid, boolean allowsItems, boolean isFlared) {
            this.isSolid = isSolid;
            this.allowsItems = allowsItems;
            this.isFlared = isFlared;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

