/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.capability;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import vazkii.arl.util.AbstractDropIn;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.handler.SimilarBlockTypeHandler;

public class ShulkerBoxDropIn
extends AbstractDropIn {
    public boolean canDropItemIn(PlayerEntity player, ItemStack stack, ItemStack incoming) {
        return this.tryAddToShulkerBox(stack, incoming, true);
    }

    public ItemStack dropItemIn(PlayerEntity player, ItemStack stack, ItemStack incoming) {
        this.tryAddToShulkerBox(stack, incoming, false);
        return stack;
    }

    private boolean tryAddToShulkerBox(ItemStack shulkerBox, ItemStack stack, boolean simulate) {
        if (!SimilarBlockTypeHandler.isShulkerBox(shulkerBox)) {
            return false;
        }
        CompoundNBT cmp = ItemNBTHelper.getCompound((ItemStack)shulkerBox, (String)"BlockEntityTag", (boolean)false);
        if (cmp != null) {
            LazyOptional handlerHolder;
            TileEntity te;
            if (!cmp.func_150297_b("id", 8)) {
                cmp = cmp.func_74737_b();
                cmp.func_74778_a("id", "minecraft:shulker_box");
            }
            if ((te = TileEntity.func_203403_c((CompoundNBT)cmp)) != null && (handlerHolder = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).isPresent()) {
                boolean did;
                IItemHandler handler = (IItemHandler)handlerHolder.orElseGet(EmptyHandler::new);
                ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)simulate);
                boolean bl = did = result.func_190926_b() || result.func_190916_E() != stack.func_190916_E();
                if (!simulate && did) {
                    stack.func_190920_e(result.func_190916_E());
                    te.func_189515_b(cmp);
                    ItemNBTHelper.setCompound((ItemStack)shulkerBox, (String)"BlockEntityTag", (CompoundNBT)cmp);
                }
                return did;
            }
        }
        return false;
    }
}

