/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.building.module.ItemFramesModule;

public class ColoredItemFrameEntity
extends ItemFrameEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(ColoredItemFrameEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final String TAG_COLOR = "DyeColor";
    private boolean didHackery = false;

    public ColoredItemFrameEntity(EntityType<? extends ColoredItemFrameEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ColoredItemFrameEntity(World worldIn, BlockPos blockPos, Direction face, int color) {
        super(ItemFramesModule.coloredFrameEntity, worldIn);
        this.field_174861_a = blockPos;
        this.func_174859_a(face);
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
    }

    public DyeColor getColor() {
        return DyeColor.func_196056_a((int)this.getColorIndex());
    }

    public int getColorIndex() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    @Nullable
    public ItemEntity func_70099_a(@Nonnull ItemStack stack, float offset) {
        if (stack.func_77973_b() == Items.field_151160_bD && !this.didHackery) {
            stack = new ItemStack((IItemProvider)ItemFramesModule.getColoredFrame(this.getColor()));
            this.didHackery = true;
        }
        return super.func_70099_a(stack, offset);
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack held = this.func_82335_i();
        if (held.func_190926_b()) {
            return new ItemStack((IItemProvider)ItemFramesModule.getColoredFrame(this.getColor()));
        }
        return held.func_77946_l();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a(TAG_COLOR, this.getColorIndex());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74762_e(TAG_COLOR));
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(this.getColorIndex());
        buffer.func_179255_a(this.field_174861_a);
        buffer.func_150787_b(this.field_174860_b.func_176745_a());
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.field_70180_af.func_187227_b(COLOR, (Object)buffer.func_150792_a());
        this.field_174861_a = buffer.func_179259_c();
        this.func_174859_a(Direction.func_82600_a((int)buffer.func_150792_a()));
    }
}

