/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.server.ServerChunkProvider;

public class BiomeLocator {
    public static BlockPos spiralOutwardsLookingForBiome(World world, Biome biomeToFind, double startX, double startZ) {
        AbstractChunkProvider provider = world.func_72863_F();
        if (provider != null && provider instanceof ServerChunkProvider) {
            ServerChunkProvider sprovider = (ServerChunkProvider)provider;
            BiomeManager manager = world.func_225523_d_();
            if (manager != null) {
                int sampleSpacing = 4 << BiomeLocator.getBiomeSize(world, sprovider.field_186029_c);
                int maxDist = sampleSpacing * 100;
                return BiomeLocator.spiralOutwardsLookingForBiome(world, manager, biomeToFind, startX, startZ, maxDist, sampleSpacing);
            }
        }
        return null;
    }

    public static BlockPos spiralOutwardsLookingForBiome(World world, BiomeManager manager, Biome biomeToFind, double startX, double startZ, int maxDist, int sampleSpace) {
        if (maxDist <= 0 || sampleSpace <= 0) {
            throw new IllegalArgumentException("maxDist and sampleSpace must be positive");
        }
        double a = (double)sampleSpace / Math.sqrt(Math.PI);
        double b = 2.0 * Math.sqrt(Math.PI);
        double x = 0.0;
        double z = 0.0;
        double dist = 0.0;
        int n = 0;
        while (dist < (double)maxDist) {
            double rootN = Math.sqrt(n);
            dist = a * rootN;
            x = startX + dist * Math.sin(b * rootN);
            z = startZ + dist * Math.cos(b * rootN);
            BlockPos pos = new BlockPos(x, (double)world.func_181545_F(), z);
            if (manager.func_226836_a_(pos) == biomeToFind) {
                return pos;
            }
            ++n;
        }
        return null;
    }

    private static int getBiomeSize(World world, ChunkGenerator<?> generator) {
        WorldType type;
        int size = 4;
        GenerationSettings settings = generator.func_201496_a_();
        if (settings instanceof OverworldGenSettings) {
            size = ((OverworldGenSettings)settings).func_202200_j();
        }
        if ((type = world.func_175624_G()) == WorldType.field_77135_d) {
            return 6;
        }
        return LayerUtil.getModdedBiomeSize((WorldType)type, (int)size);
    }
}

