/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.registry;

import com.davenonymous.bonsaitrees2.block.ModObjects;
import com.davenonymous.bonsaitrees2.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees2.registry.soil.SoilInfo;
import com.davenonymous.bonsaitrees2.util.Logz;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class SoilCompatibility {
    public static final SoilCompatibility INSTANCE = new SoilCompatibility();
    private Map<SoilInfo, Set<SaplingInfo>> treeCompatibility;
    private Map<SaplingInfo, Set<SoilInfo>> soilCompatibility;

    private void addCompatEntry(SoilInfo soil, SaplingInfo tree) {
        if (!this.soilCompatibility.containsKey((Object)tree)) {
            this.soilCompatibility.put(tree, new HashSet());
        }
        this.soilCompatibility.get((Object)tree).add(soil);
        if (!this.treeCompatibility.containsKey((Object)soil)) {
            this.treeCompatibility.put(soil, new HashSet());
        }
        this.treeCompatibility.get((Object)soil).add(tree);
    }

    public Set<SoilInfo> getValidSoilsForSapling(SaplingInfo sapling) {
        return this.soilCompatibility.getOrDefault((Object)sapling, new HashSet());
    }

    public boolean canTreeGrowOnSoil(SaplingInfo sapling, SoilInfo soil) {
        if (!this.soilCompatibility.containsKey((Object)sapling) || this.soilCompatibility.get((Object)sapling) == null) {
            return false;
        }
        return this.soilCompatibility.get((Object)sapling).contains((Object)soil);
    }

    public boolean isValidSoil(ItemStack soilStack) {
        for (SoilInfo soil : this.treeCompatibility.keySet()) {
            if (!soil.ingredient.test(soilStack)) continue;
            return true;
        }
        return false;
    }

    public void update(Collection<IRecipe<?>> recipes) {
        if (recipes == null || recipes.size() <= 0) {
            return;
        }
        List saplings = recipes.stream().filter(r -> r.func_222127_g() == ModObjects.saplingRecipeType).map(r -> (SaplingInfo)((Object)r)).collect(Collectors.toList());
        List soils = recipes.stream().filter(r -> r.func_222127_g() == ModObjects.soilRecipeType).map(r -> (SoilInfo)((Object)r)).collect(Collectors.toList());
        this.treeCompatibility = new HashMap<SoilInfo, Set<SaplingInfo>>();
        this.soilCompatibility = new HashMap<SaplingInfo, Set<SoilInfo>>();
        HashMap reverseSoilTagMap = new HashMap();
        for (SoilInfo soil : soils) {
            for (String tag : soil.tags) {
                if (!reverseSoilTagMap.containsKey(tag)) {
                    reverseSoilTagMap.put(tag, new HashSet());
                }
                ((Set)reverseSoilTagMap.get(tag)).add(soil);
            }
        }
        for (SaplingInfo sapling : saplings) {
            for (String tag : sapling.tags) {
                if (!reverseSoilTagMap.containsKey(tag)) continue;
                for (SoilInfo soil : (Set)reverseSoilTagMap.get(tag)) {
                    Logz.debug("Tree '{}' grows on '{}' because of '{}'", sapling.func_199560_c(), soil.func_199560_c(), tag);
                    this.addCompatEntry(soil, sapling);
                }
            }
        }
        Logz.info("Updated soil compatibility", new Object[0]);
    }
}

