/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.gui.widgets;

import com.davenonymous.bonsaitrees2.gui.widgets.BlockStateListEntry;
import com.davenonymous.libnonymous.gui.framework.ColorHelper;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.util.FontAwesomeIcons;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetFontAwesome;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetList;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetMultiBlockModel;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetPanel;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetTextBox;
import com.davenonymous.libnonymous.render.MultiblockBlockModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TranslationTextComponent;

public class ModelPanel
extends WidgetPanel {
    WidgetFontAwesome warningIcon;

    public ModelPanel(int width, int height, MultiblockBlockModel model) {
        this.setSize(width, height);
        WidgetTextBox modelPanelLabel = new WidgetTextBox(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.label.preview", (Object[])new Object[]{model.getBlockCount()}), -8355712);
        modelPanelLabel.setDimensions(0, 0, width - 10, 9);
        this.add((Widget)modelPanelLabel);
        WidgetMultiBlockModel modelRenderWidget = new WidgetMultiBlockModel(model);
        modelRenderWidget.setDimensions(32, 20, 74, 74);
        this.add((Widget)modelRenderWidget);
        WidgetTextBox blockTypesLabel = new WidgetTextBox(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.label.blocktypes", (Object[])new Object[]{model.refMap.size()}), -8355712);
        blockTypesLabel.setDimensions(0, 120, width - 40, 9);
        this.add((Widget)blockTypesLabel);
        WidgetList blockTypesList = new WidgetList();
        blockTypesList.setDimensions(0, 130, width - 10, 70);
        this.add((Widget)blockTypesList);
        this.warningIcon = new WidgetFontAwesome(FontAwesomeIcons.SOLID_ExclamationTriangle, WidgetFontAwesome.IconSize.MEDIUM);
        this.warningIcon.setColor(ColorHelper.COLOR_ERRORED);
        this.warningIcon.setPosition(width - 30, 110);
        this.updateWarningIcon(model);
        this.add((Widget)this.warningIcon);
        ArrayList<BlockStateListEntry> listEntries = new ArrayList<BlockStateListEntry>();
        for (Map.Entry entry : model.reverseBlocks.entrySet()) {
            BlockState state = (BlockState)entry.getKey();
            int count = ((List)entry.getValue()).size();
            BlockStateListEntry listEntry = new BlockStateListEntry(state, count, width - 12);
            listEntry.deleteIcon.addListener(MouseClickEvent.class, (event, widget) -> {
                model.removeBlockState(state);
                modelPanelLabel.setText(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.label.preview", (Object[])new Object[]{model.getBlockCount()}));
                blockTypesLabel.setText(I18n.func_135052_a((String)"bonsaitrees.gui.tree_creator.label.blocktypes", (Object[])new Object[]{model.refMap.size()}));
                blockTypesList.remove((Widget)listEntry);
                blockTypesList.scrollUp();
                this.updateWarningIcon(model);
                return WidgetEventResult.HANDLED;
            });
            listEntries.add(listEntry);
        }
        listEntries.sort(Comparator.comparingInt(o -> -o.count));
        listEntries.forEach(arg_0 -> ((WidgetList)blockTypesList).addListEntry(arg_0));
    }

    private void updateWarningIcon(MultiblockBlockModel model) {
        boolean tooManyTypes = model.refMap.size() > 26;
        boolean tooManyBlocks = model.blocks.size() > 512;
        ArrayList<TranslationTextComponent> tooltipLines = new ArrayList<TranslationTextComponent>();
        if (tooManyBlocks) {
            tooltipLines.add(new TranslationTextComponent("bonsaitrees.gui.tree_creator.warning.too_many_blocks", new Object[0]));
        }
        if (tooManyTypes) {
            tooltipLines.add(new TranslationTextComponent("bonsaitrees.gui.tree_creator.warning.too_many_types", new Object[0]));
        }
        if (tooManyBlocks || tooManyTypes) {
            tooltipLines.add(new TranslationTextComponent("bonsaitrees.gui.tree_creator.warning.isolate", new Object[0]));
            this.warningIcon.setTooltipLines(tooltipLines);
            this.warningIcon.setVisible(true);
        } else {
            this.warningIcon.setVisible(false);
        }
    }
}

