/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigurable;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.chemical.ProxiedChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.ProxiedEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.fluid.ProxiedFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.ProxiedInventorySlotHolder;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class TileEntityReactorPort
extends TileEntityReactorBlock
implements IConfigurable {
    public TileEntityReactorPort() {
        super((IBlockProvider)GeneratorsBlocks.REACTOR_PORT);
        this.delaySupplier = () -> 0;
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIGURABLE_CAPABILITY, (Object)((Object)this)));
    }

    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        return ProxiedChemicalTankHolder.create(side -> true, side -> this.getActive(), side -> this.getReactor() == null ? Collections.emptyList() : this.getReactor().controller.getGasTanks((Direction)side));
    }

    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        return ProxiedFluidTankHolder.create(side -> true, side -> this.getActive(), side -> this.getReactor() == null ? Collections.emptyList() : this.getReactor().controller.getFluidTanks((Direction)side));
    }

    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        return ProxiedEnergyContainerHolder.create(side -> true, side -> this.getActive(), side -> this.getReactor() == null ? Collections.emptyList() : this.getReactor().controller.getEnergyContainers((Direction)side));
    }

    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        return side -> this.getReactor() == null ? Collections.emptyList() : this.getReactor().controller.getHeatCapacitors(side);
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        return ProxiedInventorySlotHolder.create(side -> true, side -> this.getActive(), side -> this.getReactor() == null ? Collections.emptyList() : this.getReactor().controller.getInventorySlots((Direction)side));
    }

    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.GAS || type == SubstanceType.FLUID || type == SubstanceType.ENERGY || type == SubstanceType.HEAT) {
            return false;
        }
        return super.persists(type);
    }

    public boolean persistInventory() {
        return false;
    }

    @Override
    public boolean isFrame() {
        return false;
    }

    @Override
    protected void resetChanged() {
        World world;
        if (this.changed && (world = this.func_145831_w()) != null) {
            world.func_195593_d(this.func_174877_v(), this.getBlockType());
            this.invalidateCachedCapabilities();
        }
        super.resetChanged();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.getActive() && this.getReactor() != null) {
            GasUtils.emit((IGasTank)this.getReactor().getSteamTank(), (TileEntity)this);
            CableUtils.emit((IEnergyContainer)this.getReactor().controller.energyContainer, (TileEntity)this);
        }
    }

    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        TileEntity adj = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side));
        if (adj instanceof TileEntityReactorBlock) {
            return null;
        }
        return MekanismUtils.toOptional((LazyOptional)CapabilityUtils.getCapability((ICapabilityProvider)adj, (Capability)Capabilities.HEAT_HANDLER_CAPABILITY, (Direction)side.func_176734_d())).orElse(null);
    }

    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, new Object[]{MekanismLang.MEKANISM, GeneratorsLang.REACTOR_PORT_EJECT.translateColored(EnumColor.GRAY, new Object[]{BooleanStateDisplay.InputOutput.of((boolean)oldMode, (boolean)true)})}));
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote() && player.func_184812_l_() && this.getReactor() != null) {
            this.getReactor().setPlasmaTemp(1.0E9);
        }
        return ActionResultType.PASS;
    }
}

