/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.IHasTranslationKey;
import mekanism.common.base.ILangEntry;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TileEntityReactorLogicAdapter
extends TileEntityReactorBlock
implements IHasMode {
    public ReactorLogic logicType = ReactorLogic.DISABLED;
    public boolean activeCooled;
    private boolean prevOutputting;

    public TileEntityReactorLogicAdapter() {
        super((IBlockProvider)GeneratorsBlocks.REACTOR_LOGIC_ADAPTER);
    }

    @Override
    protected void onUpdateServer() {
        World world;
        super.onUpdateServer();
        boolean outputting = this.checkMode();
        if (outputting != this.prevOutputting && (world = this.func_145831_w()) != null) {
            world.func_195593_d(this.func_174877_v(), this.getBlockType());
        }
        this.prevOutputting = outputting;
    }

    @Override
    public boolean isFrame() {
        return false;
    }

    public boolean checkMode() {
        if (this.isRemote()) {
            return this.prevOutputting;
        }
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return false;
        }
        switch (this.logicType) {
            case READY: {
                return this.getReactor().getLastPlasmaTemp() >= this.getReactor().getIgnitionTemperature(this.activeCooled);
            }
            case CAPACITY: {
                return this.getReactor().getLastPlasmaTemp() >= this.getReactor().getMaxPlasmaTemperature(this.activeCooled);
            }
            case DEPLETED: {
                return this.getReactor().getDeuteriumTank().getStored() < (long)(this.getReactor().getInjectionRate() / 2) || this.getReactor().getTritiumTank().getStored() < (long)(this.getReactor().getInjectionRate() / 2);
            }
        }
        return false;
    }

    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        NBTUtils.setEnumIfPresent((CompoundNBT)nbtTags, (String)"logicType", ReactorLogic::byIndexStatic, logicType -> {
            this.logicType = logicType;
        });
        this.activeCooled = nbtTags.func_74767_n("activeCooled");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("logicType", this.logicType.ordinal());
        nbtTags.func_74757_a("activeCooled", this.activeCooled);
        return nbtTags;
    }

    public void nextMode() {
        this.activeCooled = !this.activeCooled;
        this.markDirty(false);
    }

    public void setLogicTypeFromPacket(ReactorLogic logicType) {
        this.logicType = logicType;
        this.markDirty(false);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(ReactorLogic::byIndexStatic, (Enum)ReactorLogic.DISABLED, () -> this.logicType, value -> {
            this.logicType = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(() -> this.activeCooled, value -> {
            this.activeCooled = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(() -> this.prevOutputting, value -> {
            this.prevOutputting = value;
        }));
    }

    public static enum ReactorLogic implements IHasTranslationKey
    {
        DISABLED(GeneratorsLang.REACTOR_LOGIC_DISABLED, GeneratorsLang.DESCRIPTION_REACTOR_DISABLED, new ItemStack((IItemProvider)Items.field_151016_H)),
        READY(GeneratorsLang.REACTOR_LOGIC_READY, GeneratorsLang.DESCRIPTION_REACTOR_READY, new ItemStack((IItemProvider)Items.field_151137_ax)),
        CAPACITY(GeneratorsLang.REACTOR_LOGIC_CAPACITY, GeneratorsLang.DESCRIPTION_REACTOR_CAPACITY, new ItemStack((IItemProvider)Items.field_151137_ax)),
        DEPLETED(GeneratorsLang.REACTOR_LOGIC_DEPLETED, GeneratorsLang.DESCRIPTION_REACTOR_DEPLETED, new ItemStack((IItemProvider)Items.field_151137_ax));

        private static final ReactorLogic[] MODES;
        private final ILangEntry name;
        private final ILangEntry description;
        private final ItemStack renderStack;

        private ReactorLogic(ILangEntry name, ILangEntry description, ItemStack stack) {
            this.name = name;
            this.description = description;
            this.renderStack = stack;
        }

        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        public ITextComponent getDescription() {
            return this.description.translate(new Object[0]);
        }

        public static ReactorLogic byIndexStatic(int index) {
            return (ReactorLogic)((Object)MathUtils.getByIndexMod((Object[])MODES, (int)index));
        }

        static {
            MODES = ReactorLogic.values();
        }
    }
}

