/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.network;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import mekanism.common.base.ILangEntry;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.container.ReactorFuelTabContainer;
import mekanism.generators.common.container.ReactorHeatTabContainer;
import mekanism.generators.common.registries.GeneratorsContainerTypes;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class PacketGeneratorsGuiButtonPress {
    private final ClickedGeneratorsTileButton tileButton;
    private final int extra;
    private final BlockPos tilePosition;

    public PacketGeneratorsGuiButtonPress(ClickedGeneratorsTileButton buttonClicked, BlockPos tilePosition) {
        this(buttonClicked, tilePosition, 0);
    }

    public PacketGeneratorsGuiButtonPress(ClickedGeneratorsTileButton buttonClicked, BlockPos tilePosition, int extra) {
        this.tileButton = buttonClicked;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public static void handle(PacketGeneratorsGuiButtonPress message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            INamedContainerProvider provider;
            TileEntityMekanism tile;
            if (!player.field_70170_p.field_72995_K && (tile = (TileEntityMekanism)MekanismUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, (BlockPos)message.tilePosition)) != null && (provider = message.tileButton.getProvider(tile, message.extra)) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, buf -> {
                    buf.func_179255_a(message.tilePosition);
                    buf.func_150787_b(message.extra);
                });
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketGeneratorsGuiButtonPress pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.tileButton);
        buf.func_179255_a(pkt.tilePosition);
        buf.func_150787_b(pkt.extra);
    }

    public static PacketGeneratorsGuiButtonPress decode(PacketBuffer buf) {
        return new PacketGeneratorsGuiButtonPress((ClickedGeneratorsTileButton)buf.func_179257_a(ClickedGeneratorsTileButton.class), buf.func_179259_c(), buf.func_150792_a());
    }

    public static enum ClickedGeneratorsTileButton {
        TAB_MAIN((tile, extra) -> {
            if (tile instanceof TileEntityTurbineCasing) {
                return new ContainerProvider((ILangEntry)GeneratorsLang.TURBINE, (i, inv, player) -> new MekanismTileContainer(GeneratorsContainerTypes.INDUSTRIAL_TURBINE, i, inv, (TileEntityMekanism)((TileEntityTurbineCasing)((Object)tile))));
            }
            return null;
        }),
        TAB_HEAT((tile, extra) -> {
            if (tile instanceof TileEntityReactorController) {
                return new ContainerProvider((ILangEntry)GeneratorsLang.HEAT_TAB, (i, inv, player) -> new ReactorHeatTabContainer(i, inv, (TileEntityReactorController)((Object)tile)));
            }
            return null;
        }),
        TAB_FUEL((tile, extra) -> {
            if (tile instanceof TileEntityReactorController) {
                return new ContainerProvider((ILangEntry)GeneratorsLang.FUEL_TAB, (i, inv, player) -> new ReactorFuelTabContainer(i, inv, (TileEntityReactorController)((Object)tile)));
            }
            return null;
        }),
        TAB_STATS((tile, extra) -> {
            if (tile instanceof TileEntityTurbineCasing) {
                return new ContainerProvider((ILangEntry)GeneratorsLang.TURBINE_STATS, (i, inv, player) -> new EmptyTileContainer(GeneratorsContainerTypes.TURBINE_STATS, i, inv, (TileEntityMekanism)((TileEntityTurbineCasing)((Object)tile))));
            }
            if (tile instanceof TileEntityReactorController) {
                return new ContainerProvider((ILangEntry)GeneratorsLang.STATS_TAB, (i, inv, player) -> new EmptyTileContainer(GeneratorsContainerTypes.REACTOR_STATS, i, inv, (TileEntityMekanism)((TileEntityReactorController)((Object)tile))));
            }
            return null;
        });

        private BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile;

        private ClickedGeneratorsTileButton(BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile) {
            this.providerFromTile = providerFromTile;
        }

        public INamedContainerProvider getProvider(TileEntityMekanism tile, int extra) {
            return this.providerFromTile.apply(tile, extra);
        }
    }
}

