/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.content.turbine.TurbineCache;
import mekanism.generators.common.registries.GeneratorsBlockTypes;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class TurbineUpdateProtocol
extends UpdateProtocol<SynchronizedTurbineData> {
    public static final long GAS_PER_TANK = 64000L;
    public static final int MAX_BLADES = 28;

    public TurbineUpdateProtocol(TileEntityTurbineCasing tile) {
        super((TileEntityMultiblock)tile);
    }

    protected UpdateProtocol.CasingType getCasingType(BlockPos pos) {
        Block block = this.pointer.func_145831_w().func_180495_p(pos).func_177230_c();
        if (BlockTypeTile.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.TURBINE_CASING})) {
            return UpdateProtocol.CasingType.FRAME;
        }
        if (BlockTypeTile.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.TURBINE_VALVE})) {
            return UpdateProtocol.CasingType.VALVE;
        }
        if (BlockTypeTile.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.TURBINE_VENT})) {
            return UpdateProtocol.CasingType.OTHER;
        }
        return UpdateProtocol.CasingType.INVALID;
    }

    protected boolean isValidInnerNode(BlockPos pos) {
        if (super.isValidInnerNode(pos)) {
            return true;
        }
        TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.pointer.func_145831_w(), (BlockPos)pos);
        return tile instanceof TileEntityTurbineRotor || tile instanceof TileEntityRotationalComplex || tile instanceof TileEntityPressureDisperser || tile instanceof TileEntityElectromagneticCoil || tile instanceof TileEntitySaturatingCondenser;
    }

    protected boolean canForm(SynchronizedTurbineData structure) {
        if (structure.volLength % 2 != 1 || structure.volWidth % 2 != 1) {
            return false;
        }
        int centerX = structure.minLocation.x + (structure.volLength - 1) / 2;
        int centerZ = structure.minLocation.z + (structure.volWidth - 1) / 2;
        Coord4D complex = null;
        ObjectOpenHashSet turbines = new ObjectOpenHashSet();
        ObjectOpenHashSet dispersers = new ObjectOpenHashSet();
        ObjectOpenHashSet coils = new ObjectOpenHashSet();
        ObjectOpenHashSet condensers = new ObjectOpenHashSet();
        for (Coord4D coord : this.innerNodes) {
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.pointer.func_145831_w(), (BlockPos)coord.getPos());
            if (tile instanceof TileEntityRotationalComplex) {
                if (complex != null || coord.x != centerX || coord.z != centerZ) {
                    return false;
                }
                structure.internalLocations.add(coord);
                complex = coord;
                continue;
            }
            if (tile instanceof TileEntityTurbineRotor) {
                if (coord.x != centerX || coord.z != centerZ) {
                    return false;
                }
                turbines.add(coord);
                continue;
            }
            if (tile instanceof TileEntityPressureDisperser) {
                dispersers.add(coord);
                continue;
            }
            if (tile instanceof TileEntityElectromagneticCoil) {
                coils.add(coord);
                continue;
            }
            if (!(tile instanceof TileEntitySaturatingCondenser)) continue;
            condensers.add(coord);
        }
        if (complex == null) {
            return false;
        }
        int rotors = complex.y - structure.minLocation.y + 1;
        int innerRadius = (Math.min(structure.volLength, structure.volWidth) - 3) / 2;
        if (innerRadius < rotors / 4) {
            return false;
        }
        for (int x = complex.x - innerRadius; x <= complex.x + innerRadius; ++x) {
            for (int z = complex.z - innerRadius; z <= complex.z + innerRadius; ++z) {
                if (x == centerX && z == centerZ) continue;
                TileEntityPressureDisperser tile = (TileEntityPressureDisperser)MekanismUtils.getTileEntity(TileEntityPressureDisperser.class, (IBlockReader)this.pointer.func_145831_w(), (BlockPos)new BlockPos(x, complex.y, z));
                if (tile == null) {
                    return false;
                }
                dispersers.remove(new Coord4D((double)x, (double)complex.y, (double)z, this.pointer.func_145831_w().func_201675_m().func_186058_p()));
            }
        }
        if (!dispersers.isEmpty()) {
            return false;
        }
        for (Coord4D coord : condensers) {
            if (coord.y > complex.y) continue;
            return false;
        }
        structure.condensers = condensers.size();
        int turbineHeight = 0;
        int blades = 0;
        for (int y = complex.y - 1; y > structure.minLocation.y; --y) {
            TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)MekanismUtils.getTileEntity(TileEntityTurbineRotor.class, (IBlockReader)this.pointer.func_145831_w(), (BlockPos)new BlockPos(centerX, y, centerZ));
            if (rotor == null) {
                return false;
            }
            ++turbineHeight;
            blades += rotor.getHousedBlades();
            structure.internalLocations.add(Coord4D.get((TileEntity)rotor));
            turbines.remove(new Coord4D((double)centerX, (double)y, (double)centerZ, this.pointer.func_145831_w().func_201675_m().func_186058_p()));
        }
        if (!turbines.isEmpty()) {
            return false;
        }
        structure.blades = blades;
        Coord4D startCoord = complex.offset(Direction.UP);
        if (MekanismUtils.getTileEntity(TileEntityElectromagneticCoil.class, (IBlockReader)this.pointer.func_145831_w(), (BlockPos)startCoord.getPos()) != null) {
            structure.coils = new UpdateProtocol.NodeCounter(new UpdateProtocol.NodeChecker(){

                public boolean isValid(Coord4D coord) {
                    return MekanismUtils.getTileEntity(TileEntityElectromagneticCoil.class, (IBlockReader)TurbineUpdateProtocol.this.pointer.func_145831_w(), (BlockPos)coord.getPos()) != null;
                }
            }).calculate(startCoord);
        }
        if (coils.size() > structure.coils) {
            return false;
        }
        for (Coord4D coord : structure.locations) {
            if (MekanismUtils.getTileEntity(TileEntityTurbineVent.class, (IBlockReader)this.pointer.func_145831_w(), (BlockPos)coord.getPos()) == null) continue;
            if (coord.y < complex.y) {
                return false;
            }
            ++structure.vents;
        }
        structure.lowerVolume = structure.volLength * structure.volWidth * turbineHeight;
        structure.complex = complex;
        return true;
    }

    protected MultiblockCache<SynchronizedTurbineData> getNewCache() {
        return new TurbineCache();
    }

    protected SynchronizedTurbineData getNewStructure() {
        return new SynchronizedTurbineData((TileEntityTurbineCasing)this.pointer);
    }

    protected MultiblockManager<SynchronizedTurbineData> getManager() {
        return MekanismGenerators.turbineManager;
    }

    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedTurbineData> cache, MultiblockCache<SynchronizedTurbineData> merge) {
        TurbineCache turbineCache = (TurbineCache)cache;
        TurbineCache mergeCache = (TurbineCache)merge;
        StorageUtils.mergeTanks((IChemicalTank)((IChemicalTank)turbineCache.getGasTanks(null).get(0)), (IChemicalTank)((IChemicalTank)mergeCache.getGasTanks(null).get(0)));
        StorageUtils.mergeContainers((IEnergyContainer)turbineCache.getEnergyContainers(null).get(0), (IEnergyContainer)mergeCache.getEnergyContainers(null).get(0));
        turbineCache.dumpMode = mergeCache.dumpMode;
    }

    protected void onFormed() {
        super.onFormed();
        if (!((SynchronizedTurbineData)this.structureFound).gasTank.isEmpty()) {
            ((SynchronizedTurbineData)this.structureFound).gasTank.setStackSize(Math.min(((SynchronizedTurbineData)this.structureFound).gasTank.getStored(), ((SynchronizedTurbineData)this.structureFound).getSteamCapacity()), Action.EXECUTE);
        }
        if (!((SynchronizedTurbineData)this.structureFound).energyContainer.isEmpty()) {
            ((SynchronizedTurbineData)this.structureFound).energyContainer.setEnergy(((SynchronizedTurbineData)this.structureFound).energyContainer.getEnergy().min(((SynchronizedTurbineData)this.structureFound).getEnergyCapacity()));
        }
    }
}

