/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.config;

import java.util.ArrayList;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import mekanism.common.config.value.CachedResourceLocationListValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class GeneratorsConfig
extends BaseMekanismConfig {
    private static final String TURBINE_CATEGORY = "turbine";
    private static final String WIND_CATEGORY = "wind_generator";
    private static final String HEAT_CATEGORY = "heat_generator";
    private static final String HOHLRAUM_CATEGORY = "hohlraum";
    private final ForgeConfigSpec configSpec;
    public final CachedFloatingLongValue advancedSolarGeneration;
    public final CachedFloatingLongValue bioGeneration;
    public final CachedFloatingLongValue heatGeneration;
    public final CachedFloatingLongValue heatGenerationLava;
    public final CachedFloatingLongValue heatGenerationNether;
    public final CachedFloatingLongValue solarGeneration;
    public final CachedIntValue turbineBladesPerCoil;
    public final CachedDoubleValue turbineVentGasFlow;
    public final CachedDoubleValue turbineDisperserGasFlow;
    public final CachedIntValue condenserRate;
    public final CachedFloatingLongValue energyPerFusionFuel;
    public final CachedFloatingLongValue windGenerationMin;
    public final CachedFloatingLongValue windGenerationMax;
    public final CachedIntValue windGenerationMinY;
    public final CachedIntValue windGenerationMaxY;
    public final CachedResourceLocationListValue windGenerationDimBlacklist;
    public final CachedLongValue hohlraumMaxGas;
    public final CachedLongValue hohlraumFillRate;

    GeneratorsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Generators Config. This config is synced between server and client.").push("generators");
        this.bioGeneration = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Amount of energy in Joules the Bio Generator produces per tick.", (String)"bioGeneration", (FloatingLong)FloatingLong.createConst((long)350L));
        this.energyPerFusionFuel = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Affects the Injection Rate, Max Temp, and Ignition Temp.", (String)"energyPerFusionFuel", (FloatingLong)FloatingLong.createConst((long)5000000L));
        this.solarGeneration = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Peak output for the Solar Generator. Note: It can go higher than this value in some extreme environments.", (String)"solarGeneration", (FloatingLong)FloatingLong.createConst((long)50L));
        this.advancedSolarGeneration = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Peak output for the Advanced Solar Generator. Note: It can go higher than this value in some extreme environments.", (String)"advancedSolarGeneration", (FloatingLong)FloatingLong.createConst((long)300L));
        builder.comment("Heat Generator Settings").push(HEAT_CATEGORY);
        this.heatGeneration = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Amount of energy in Joules the Heat Generator produces per tick. (heatGenerationLava * heatGenerationLava) + heatGenerationNether", (String)"heatGeneration", (FloatingLong)FloatingLong.createConst((long)200L));
        this.heatGenerationLava = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Multiplier of effectiveness of Lava in the Heat Generator.", (String)"heatGenerationLava", (FloatingLong)FloatingLong.createConst((long)30L));
        this.heatGenerationNether = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Add this amount of Joules to the energy produced by a heat generator if it is in the Nether.", (String)"heatGenerationNether", (FloatingLong)FloatingLong.createConst((long)100L));
        builder.pop();
        builder.comment("Turbine Settings").push(TURBINE_CATEGORY);
        this.turbineBladesPerCoil = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The number of blades on each turbine coil per blade applied.").define("turbineBladesPerCoil", (Object)4));
        this.turbineVentGasFlow = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The rate at which steam is vented into the turbine.").define("turbineVentGasFlow", (Object)32000.0));
        this.turbineDisperserGasFlow = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The rate at which steam is dispersed into the turbine.").define("turbineDisperserGasFlow", (Object)1280.0));
        this.condenserRate = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The rate at which steam is condensed in the turbine.").define("condenserRate", (Object)64000));
        builder.pop();
        builder.comment("Wind Generator Settings").push(WIND_CATEGORY);
        this.windGenerationMin = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Minimum base generation value of the Wind Generator.", (String)"windGenerationMin", (FloatingLong)FloatingLong.createConst((long)60L));
        this.windGenerationMax = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Maximum base generation value of the Wind Generator.", (String)"windGenerationMax", (FloatingLong)FloatingLong.createConst((long)480L));
        this.windGenerationMinY = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The minimum Y value that affects the Wind Generators Power generation.").define("windGenerationMinY", (Object)24));
        this.windGenerationMaxY = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The maximum Y value that affects the Wind Generators Power generation.").define("windGenerationMaxY", (Object)255, value -> value instanceof Integer && (Integer)value > this.windGenerationMinY.get()));
        this.windGenerationDimBlacklist = CachedResourceLocationListValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The list of dimension ids that the Wind Generator will not generate power in.").defineList("windGenerationDimBlacklist", new ArrayList(), o -> {
            ResourceLocation dim;
            if (o instanceof String && (dim = ResourceLocation.func_208304_a((String)((String)o).toLowerCase())) != null) {
                DimensionType dimensionType = DimensionType.func_193417_a((ResourceLocation)dim);
                if (dimensionType == DimensionType.field_223227_a_) {
                    return dim.equals((Object)DimensionType.field_223227_a_.getRegistryName());
                }
                return true;
            }
            return false;
        }));
        builder.pop();
        builder.comment("Hohlraum Settings").push(HOHLRAUM_CATEGORY);
        this.hohlraumMaxGas = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Hohlraum capacity in mB.").defineInRange("maxGas", 10L, 1L, Long.MAX_VALUE));
        this.hohlraumFillRate = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of DT-Fuel Hohlraum can accept per tick.").defineInRange("fillRate", 1L, 1L, Long.MAX_VALUE));
        builder.pop();
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "generators";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

