/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.core.BiomesOPlenty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ModCompatibility {
    public static void setup() {
        ModCompatibility.copyModBiomeWeights();
    }

    private static void copyModBiomeWeights() {
        try {
            List[] vanillaBiomes = (List[])ObfuscationReflectionHelper.findMethod(BiomeManager.class, (String)"setupBiomes", (Class[])new Class[0]).invoke(null, new Object[0]);
            for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
                ArrayList entries = Lists.newArrayList();
                ArrayList vanillaEntries = Lists.newArrayList();
                for (BiomeManager.BiomeEntry entry : BiomeManager.getBiomes((BiomeManager.BiomeType)type)) {
                    entries.add(new WrappedBiomeEntry(entry));
                }
                for (BiomeManager.BiomeEntry entry : vanillaBiomes[type.ordinal()]) {
                    vanillaEntries.add(new WrappedBiomeEntry(entry));
                }
                entries.removeAll(vanillaEntries);
                for (WrappedBiomeEntry wrappedEntry : entries) {
                    ModCompatibility.remapBiomeToBoP(((WrappedBiomeEntry)wrappedEntry).biomeEntry.biome, type, ((WrappedBiomeEntry)wrappedEntry).biomeEntry.field_76292_a);
                }
            }
        }
        catch (Exception e) {
            BiomesOPlenty.logger.error("An error has occurred whilst copying mod biomes");
            e.printStackTrace();
            return;
        }
    }

    private static void remapBiomeToBoP(Biome biome, BiomeManager.BiomeType type, int weight) {
        for (BOPClimates climate : BOPClimates.values()) {
            ArrayList entries = Lists.newArrayList();
            entries.addAll(climate.getLandBiomes());
            entries.addAll(climate.getIslandBiomes());
            for (BOPClimates.WeightedBiomeEntry entry : entries) {
                if (entry.biome != biome) continue;
                return;
            }
        }
        for (BOPClimates climate : BOPClimates.values()) {
            if (climate.biomeType != type) continue;
            climate.addBiome(weight, biome);
        }
    }

    private static class WrappedBiomeEntry {
        private BiomeManager.BiomeEntry biomeEntry;

        private WrappedBiomeEntry(BiomeManager.BiomeEntry biomeEntry) {
            this.biomeEntry = biomeEntry;
        }

        public boolean equals(Object input) {
            if (input == null) {
                return false;
            }
            if (input == this) {
                return true;
            }
            if (!(input instanceof WrappedBiomeEntry)) {
                return false;
            }
            WrappedBiomeEntry other = (WrappedBiomeEntry)input;
            return other.biomeEntry.field_76292_a == this.biomeEntry.field_76292_a && other.biomeEntry.biome == this.biomeEntry.biome;
        }
    }
}

