/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import com.Da_Technomancer.essentials.tileentities.RedstoneTransmitterTileEntity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class RedstoneReceiverTileEntity
extends TileEntity
implements ILinkTE {
    private BlockPos src = null;
    @ObjectHolder(value="redstone_receiver")
    private static TileEntityType<RedstoneReceiverTileEntity> type = null;
    private LazyOptional<IRedstoneHandler> circOpt = LazyOptional.of(() -> new CircHandler());
    private WeakReference<LazyOptional<IRedstoneHandler>> circRef = new WeakReference<LazyOptional<IRedstoneHandler>>(this.circOpt);
    private final ArrayList<WeakReference<LazyOptional<IRedstoneHandler>>> dependents = new ArrayList(1);

    public RedstoneReceiverTileEntity() {
        super(type);
    }

    @Override
    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
    }

    @Override
    public boolean canBeginLinking() {
        return false;
    }

    protected void setSrc(BlockPos srcIn) {
        this.src = srcIn;
        this.func_70296_d();
        this.notifyOutputChange();
    }

    public void dye(DyeColor color) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(ESProperties.COLOR) != color) {
            BlockPos worldSrc;
            TileEntity srcTE;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(ESProperties.COLOR, (Comparable)color));
            if (this.src != null && (srcTE = this.field_145850_b.func_175625_s(worldSrc = this.field_174879_c.func_177971_a((Vec3i)this.src))) instanceof RedstoneTransmitterTileEntity) {
                ((RedstoneTransmitterTileEntity)srcTE).dye(color);
            }
        }
    }

    protected void notifyOutputChange() {
        this.field_145850_b.func_195593_d(this.field_174879_c, (Block)ESBlocks.redstoneReceiver);
        for (int i = 0; i < this.dependents.size(); ++i) {
            LazyOptional optional;
            WeakReference<LazyOptional<IRedstoneHandler>> depend = this.dependents.get(i);
            if (depend == null || (optional = (LazyOptional)depend.get()) == null || !optional.isPresent()) {
                this.dependents.remove(i);
                --i;
                continue;
            }
            ((IRedstoneHandler)optional.orElseThrow(NullPointerException::new)).notifyInputChange(this.circRef);
        }
    }

    public void buildDependents() {
        this.dependents.clear();
        for (Direction dir : Direction.values()) {
            LazyOptional otherOpt;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (te == null || !(otherOpt = te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.func_176734_d())).isPresent()) continue;
            IRedstoneHandler otherHandler = (IRedstoneHandler)otherOpt.orElseThrow(NullPointerException::new);
            otherHandler.findDependents(this.circRef, 0, dir.func_176734_d(), dir);
        }
    }

    public float getPower() {
        TileEntity te;
        if (this.src != null && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)this.src))) instanceof RedstoneTransmitterTileEntity) {
            return ((RedstoneTransmitterTileEntity)te).getOutput();
        }
        return 0.0f;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("src")) {
            this.src = BlockPos.func_218283_e((long)nbt.func_74763_f("src"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.src != null) {
            nbt.func_74772_a("src", this.src.func_218275_a());
        }
        return nbt;
    }

    @Override
    public TileEntity getTE() {
        return this;
    }

    @Override
    public boolean canLink(ILinkTE otherTE) {
        return false;
    }

    public HashSet<BlockPos> getLinks() {
        return new HashSet<BlockPos>(1);
    }

    @Override
    public int getMaxLinks() {
        return 0;
    }

    @Override
    public int getRange() {
        return (Integer)ESConfig.wirelessRange.get();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.circOpt.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY) {
            return this.circOpt;
        }
        return super.getCapability(cap, side);
    }

    private class CircHandler
    implements IRedstoneHandler {
        private CircHandler() {
        }

        @Override
        public float getOutput() {
            return RedstoneReceiverTileEntity.this.getPower();
        }

        @Override
        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide) {
        }

        @Override
        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide) {
            LazyOptional depenOption = (LazyOptional)dependency.get();
            if (depenOption != null && depenOption.isPresent()) {
                IRedstoneHandler depHandler = (IRedstoneHandler)depenOption.orElseThrow(NullPointerException::new);
                depHandler.addSrc(RedstoneReceiverTileEntity.this.circRef, nominalSide);
                if (!RedstoneReceiverTileEntity.this.dependents.contains(dependency)) {
                    RedstoneReceiverTileEntity.this.dependents.add(dependency);
                }
            }
        }

        @Override
        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> src, Direction fromSide) {
        }

        @Override
        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> dependent, Direction toSide) {
            if (!RedstoneReceiverTileEntity.this.dependents.contains(dependent)) {
                RedstoneReceiverTileEntity.this.dependents.add(dependent);
            }
        }

        @Override
        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> src) {
        }
    }
}

