/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.IWireConnect;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import com.Da_Technomancer.essentials.tileentities.RedstoneTransmitterTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstoneTransmitter
extends ContainerBlock
implements IWireConnect {
    public RedstoneTransmitter() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.5f).func_200947_a(SoundType.field_185851_d));
        String name = "redstone_transmitter";
        this.setRegistryName(name);
        ESBlocks.toRegister.add((Block)this);
        ESBlocks.blockAddQue(this);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(ESProperties.COLOR, (Comparable)DyeColor.WHITE));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileEntity te;
        worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 2, TickPriority.HIGH);
        if (blockIn != Blocks.field_150488_af && !(blockIn instanceof RedstoneDiodeBlock) && (te = worldIn.func_175625_s(pos)) instanceof RedstoneTransmitterTileEntity) {
            ((RedstoneTransmitterTileEntity)te).buildConnections();
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.func_220069_a(state, worldIn, pos, (Block)this, pos, false);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        TileEntity rawTE = worldIn.func_175625_s(pos);
        if (rawTE instanceof RedstoneTransmitterTileEntity) {
            ((RedstoneTransmitterTileEntity)rawTE).refreshOutput();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileEntity te = worldIn.func_175625_s(pos);
        if (ILinkTE.isLinkTool(heldItem) && te instanceof RedstoneTransmitterTileEntity) {
            if (!worldIn.field_72995_K) {
                ((RedstoneTransmitterTileEntity)te).wrench(heldItem, playerIn);
            }
            return ActionResultType.SUCCESS;
        }
        Item item = heldItem.func_77973_b();
        if (item instanceof DyeItem && te instanceof RedstoneTransmitterTileEntity) {
            if (!worldIn.field_72995_K) {
                ((RedstoneTransmitterTileEntity)te).dye(((DyeItem)item).func_195962_g());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.reds_trans.desc", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.reds_trans.linking", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.reds_trans.dyes", new Object[0]));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new RedstoneTransmitterTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new IProperty[]{ESProperties.COLOR});
    }

    @Override
    public boolean canConnect(Direction side, BlockState state) {
        return true;
    }
}

