/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractTile;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.tileentities.CircuitTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractCircuit
extends AbstractTile {
    protected AbstractCircuit(String name) {
        super(name);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)ESProperties.HORIZ_FACING, (Comparable)context.func_195992_f());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ESProperties.HORIZ_FACING});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (ESConfig.isWrench(playerIn.func_184586_b(hand))) {
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)ESProperties.HORIZ_FACING, (Comparable)((Direction)state.func_177229_b((IProperty)ESProperties.HORIZ_FACING)).func_176746_e()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CircuitTileEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof CircuitTileEntity && !worldIn.field_72995_K) {
            ((CircuitTileEntity)te).builtConnections = false;
            ((CircuitTileEntity)te).buildConnections();
        } else {
            worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 2, TickPriority.VERY_HIGH);
        }
    }

    @Override
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (blockIn == Blocks.field_150488_af || blockIn instanceof RedstoneDiodeBlock) {
            worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 2, TickPriority.HIGH);
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof CircuitTileEntity) {
                ((CircuitTileEntity)te).buildConnections();
            }
        } else {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof CircuitTileEntity) {
                ((CircuitTileEntity)te).builtConnections = false;
                ((CircuitTileEntity)te).buildConnections();
            }
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public int func_180656_a(BlockState state, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileEntity te;
        if (side.func_176734_d() == state.func_177229_b((IProperty)ESProperties.HORIZ_FACING) && (te = blockAccess.func_175625_s(pos)) instanceof CircuitTileEntity) {
            return RedstoneUtil.clampToVanilla(((CircuitTileEntity)te).getOutput());
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return side != null && (side.func_176734_d() == state.func_177229_b((IProperty)ESProperties.HORIZ_FACING) || this.useInput(CircuitTileEntity.Orient.getOrient(side.func_176734_d(), (Direction)state.func_177229_b((IProperty)ESProperties.HORIZ_FACING))));
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof CircuitTileEntity) {
            ((CircuitTileEntity)te).recalculateOutput();
        }
    }

    @Override
    public boolean canConnect(Direction side, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((IProperty)ESProperties.HORIZ_FACING);
        return side == facing || this.useInput(CircuitTileEntity.Orient.getOrient(side, facing));
    }

    public abstract boolean useInput(CircuitTileEntity.Orient var1);

    public abstract float getOutput(float var1, float var2, float var3, CircuitTileEntity var4);
}

